/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.schema.DataField;
import org.apache.flink.table.store.file.schema.KeyValueFieldsExtractor;
import org.apache.flink.table.store.file.schema.RowDataType;
import org.apache.flink.table.store.file.schema.SchemaEvolutionUtil;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.store.utils.Projection;
import org.apache.flink.table.types.logical.RowType;

public class BulkFormatMapping {
    @Nullable
    private final int[] indexMapping;
    private final BulkFormat<RowData, FileSourceSplit> bulkFormat;

    public BulkFormatMapping(int[] indexMapping, BulkFormat<RowData, FileSourceSplit> bulkFormat) {
        this.indexMapping = indexMapping;
        this.bulkFormat = bulkFormat;
    }

    @Nullable
    public int[] getIndexMapping() {
        return this.indexMapping;
    }

    public BulkFormat<RowData, FileSourceSplit> getReaderFactory() {
        return this.bulkFormat;
    }

    public static BulkFormatMappingBuilder newBuilder(FileFormat fileFormat, KeyValueFieldsExtractor extractor, int[][] keyProjection, int[][] valueProjection, @Nullable List<Predicate> filters) {
        return new BulkFormatMappingBuilder(fileFormat, extractor, keyProjection, valueProjection, filters);
    }

    public static class BulkFormatMappingBuilder {
        private final FileFormat fileFormat;
        private final KeyValueFieldsExtractor extractor;
        private final int[][] keyProjection;
        private final int[][] valueProjection;
        @Nullable
        private final List<Predicate> filters;

        private BulkFormatMappingBuilder(FileFormat fileFormat, KeyValueFieldsExtractor extractor, int[][] keyProjection, int[][] valueProjection, @Nullable List<Predicate> filters) {
            this.fileFormat = fileFormat;
            this.extractor = extractor;
            this.keyProjection = keyProjection;
            this.valueProjection = valueProjection;
            this.filters = filters;
        }

        public BulkFormatMapping build(TableSchema tableSchema, TableSchema dataSchema) {
            List<DataField> tableKeyFields = this.extractor.keyFields(tableSchema);
            List<DataField> tableValueFields = this.extractor.valueFields(tableSchema);
            int[][] tableProjection = KeyValue.project(this.keyProjection, this.valueProjection, tableKeyFields.size());
            List<DataField> dataKeyFields = this.extractor.keyFields(dataSchema);
            List<DataField> dataValueFields = this.extractor.valueFields(dataSchema);
            RowType keyType = RowDataType.toRowType(false, dataKeyFields);
            RowType valueType = RowDataType.toRowType(false, dataValueFields);
            RowType dataRecordType = KeyValue.schema(keyType, valueType);
            int[][] dataKeyProjection = SchemaEvolutionUtil.createDataProjection(tableKeyFields, dataKeyFields, this.keyProjection);
            int[][] dataValueProjection = SchemaEvolutionUtil.createDataProjection(tableValueFields, dataValueFields, this.valueProjection);
            int[][] dataProjection = KeyValue.project(dataKeyProjection, dataValueProjection, dataKeyFields.size());
            int[] indexMapping = SchemaEvolutionUtil.createIndexMapping(Projection.of(tableProjection).toTopLevelIndexes(), tableKeyFields, tableValueFields, Projection.of(dataProjection).toTopLevelIndexes(), dataKeyFields, dataValueFields);
            List<Predicate> dataFilters = tableSchema.id() == dataSchema.id() ? this.filters : SchemaEvolutionUtil.createDataFilters(tableSchema.fields(), dataSchema.fields(), this.filters);
            return new BulkFormatMapping(indexMapping, this.fileFormat.createReaderFactory(dataRecordType, dataProjection, dataFilters));
        }
    }
}

