/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.stats;

import java.util.ArrayList;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.store.file.stats.BinaryTableStats;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.store.utils.RowDataUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class FieldStatsArraySerializer {
    private final RowDataSerializer serializer;
    private final RowData.FieldGetter[] fieldGetters;
    @Nullable
    private final int[] indexMapping;

    public FieldStatsArraySerializer(RowType type) {
        this(type, null);
    }

    public FieldStatsArraySerializer(RowType type, int[] indexMapping) {
        RowType safeType = FieldStatsArraySerializer.toAllFieldsNullableRowType(type);
        this.serializer = new RowDataSerializer(safeType);
        this.fieldGetters = (RowData.FieldGetter[])IntStream.range(0, safeType.getFieldCount()).mapToObj(i -> RowDataUtils.createNullCheckingFieldGetter(safeType.getTypeAt(i), i)).toArray(RowData.FieldGetter[]::new);
        this.indexMapping = indexMapping;
    }

    public BinaryTableStats toBinary(FieldStats[] stats) {
        int rowFieldCount = stats.length;
        GenericRowData minValues = new GenericRowData(rowFieldCount);
        GenericRowData maxValues = new GenericRowData(rowFieldCount);
        long[] nullCounts = new long[rowFieldCount];
        for (int i = 0; i < rowFieldCount; ++i) {
            minValues.setField(i, stats[i].minValue());
            maxValues.setField(i, stats[i].maxValue());
            nullCounts[i] = stats[i].nullCount();
        }
        return new BinaryTableStats(this.serializer.toBinaryRow((RowData)minValues).copy(), this.serializer.toBinaryRow((RowData)maxValues).copy(), nullCounts, stats);
    }

    public FieldStats[] fromBinary(BinaryTableStats array) {
        return this.fromBinary(array, null);
    }

    public FieldStats[] fromBinary(BinaryTableStats array, @Nullable Long rowCount) {
        int fieldCount = this.indexMapping == null ? this.fieldGetters.length : this.indexMapping.length;
        FieldStats[] stats = new FieldStats[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            int fieldIndex;
            int n = fieldIndex = this.indexMapping == null ? i : this.indexMapping[i];
            if (fieldIndex < 0 || fieldIndex >= array.min().getArity()) {
                if (rowCount == null) {
                    throw new RuntimeException("Schema Evolution for stats needs row count.");
                }
                stats[i] = new FieldStats(null, null, rowCount);
                continue;
            }
            stats[i] = new FieldStats(this.fieldGetters[fieldIndex].getFieldOrNull((RowData)array.min()), this.fieldGetters[fieldIndex].getFieldOrNull((RowData)array.max()), array.nullCounts()[fieldIndex]);
        }
        return stats;
    }

    public static RowType schema() {
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        fields.add(new RowType.RowField("_MIN_VALUES", (LogicalType)SerializationUtils.newBytesType(false)));
        fields.add(new RowType.RowField("_MAX_VALUES", (LogicalType)SerializationUtils.newBytesType(false)));
        fields.add(new RowType.RowField("_NULL_COUNTS", (LogicalType)new ArrayType((LogicalType)new BigIntType(false))));
        return new RowType(fields);
    }

    private static RowType toAllFieldsNullableRowType(RowType rowType) {
        return RowType.of((LogicalType[])((LogicalType[])rowType.getFields().stream().map(f -> f.getType().copy(true)).toArray(LogicalType[]::new)), (String[])rowType.getFieldNames().toArray(new String[0]));
    }
}

