/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.predicate.LeafPredicate;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateReplaceVisitor;
import org.apache.flink.table.store.file.schema.DataField;
import org.apache.flink.util.Preconditions;

public class SchemaEvolutionUtil {
    private static final int NULL_FIELD_INDEX = -1;

    @Nullable
    public static int[] createIndexMapping(List<DataField> tableFields, List<DataField> dataFields) {
        int i;
        int[] indexMapping = new int[tableFields.size()];
        HashMap<Integer, Integer> fieldIdToIndex = new HashMap<Integer, Integer>();
        for (i = 0; i < dataFields.size(); ++i) {
            fieldIdToIndex.put(dataFields.get(i).id(), i);
        }
        for (i = 0; i < tableFields.size(); ++i) {
            int fieldId = tableFields.get(i).id();
            Integer dataFieldIndex = (Integer)fieldIdToIndex.get(fieldId);
            indexMapping[i] = dataFieldIndex != null ? dataFieldIndex : -1;
        }
        for (i = 0; i < indexMapping.length; ++i) {
            if (indexMapping[i] == i) continue;
            return indexMapping;
        }
        return null;
    }

    @Nullable
    public static int[] createIndexMapping(int[] tableProjection, List<DataField> tableFields, int[] dataProjection, List<DataField> dataFields) {
        ArrayList<DataField> tableProjectFields = new ArrayList<DataField>(tableProjection.length);
        for (int index : tableProjection) {
            tableProjectFields.add(tableFields.get(index));
        }
        ArrayList<DataField> dataProjectFields = new ArrayList<DataField>(dataProjection.length);
        for (int index : dataProjection) {
            dataProjectFields.add(dataFields.get(index));
        }
        return SchemaEvolutionUtil.createIndexMapping(tableProjectFields, dataProjectFields);
    }

    @Nullable
    public static int[] createIndexMapping(int[] tableProjection, List<DataField> tableKeyFields, List<DataField> tableValueFields, int[] dataProjection, List<DataField> dataKeyFields, List<DataField> dataValueFields) {
        int maxKeyId = Math.max(tableKeyFields.stream().mapToInt(DataField::id).max().orElse(0), dataKeyFields.stream().mapToInt(DataField::id).max().orElse(0));
        List<DataField> tableFields = KeyValue.createKeyValueFields(tableKeyFields, tableValueFields, maxKeyId);
        List<DataField> dataFields = KeyValue.createKeyValueFields(dataKeyFields, dataValueFields, maxKeyId);
        return SchemaEvolutionUtil.createIndexMapping(tableProjection, tableFields, dataProjection, dataFields);
    }

    public static int[][] createDataProjection(List<DataField> tableFields, List<DataField> dataFields, int[][] tableProjection) {
        List dataFieldIdList = dataFields.stream().map(DataField::id).collect(Collectors.toList());
        return (int[][])Arrays.stream(tableProjection).map(p -> Arrays.copyOf(p, ((int[])p).length)).peek(p -> {
            int fieldId = ((DataField)tableFields.get(p[0])).id();
            p[0] = dataFieldIdList.indexOf(fieldId);
        }).filter(p -> p[0] >= 0).toArray(x$0 -> new int[x$0][]);
    }

    @Nullable
    public static List<Predicate> createDataFilters(List<DataField> tableFields, List<DataField> dataFields, List<Predicate> filters) {
        if (filters == null) {
            return null;
        }
        Map<String, DataField> nameToTableFields = tableFields.stream().collect(Collectors.toMap(DataField::name, f -> f));
        LinkedHashMap idToDataFields = new LinkedHashMap();
        dataFields.forEach(f -> idToDataFields.put(f.id(), f));
        ArrayList<Predicate> dataFilters = new ArrayList<Predicate>(filters.size());
        PredicateReplaceVisitor visitor = predicate -> {
            DataField tableField = (DataField)Preconditions.checkNotNull(nameToTableFields.get(predicate.fieldName()), (String)String.format("Find no field %s", predicate.fieldName()));
            DataField dataField = (DataField)idToDataFields.get(tableField.id());
            if (dataField == null) {
                return Optional.empty();
            }
            return Optional.of(new LeafPredicate(predicate.function(), predicate.type(), SchemaEvolutionUtil.indexOf(dataField, idToDataFields), dataField.name(), predicate.literals()));
        };
        for (Predicate predicate2 : filters) {
            predicate2.visit(visitor).ifPresent(dataFilters::add);
        }
        return dataFilters;
    }

    private static int indexOf(DataField dataField, LinkedHashMap<Integer, DataField> dataFields) {
        int index = 0;
        for (Map.Entry<Integer, DataField> entry : dataFields.entrySet()) {
            if (dataField.id() == entry.getKey().intValue()) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException(String.format("Can't find data field %s", dataField.name()));
    }
}

