/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.schema;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.table.store.file.schema.DataType;
import org.apache.flink.table.store.file.utils.JsonSerdeUtil;

public final class DataField
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int id;
    private final String name;
    private final DataType type;
    @Nullable
    private final String description;

    public DataField(int id, String name, DataType dataType) {
        this(id, name, dataType, null);
    }

    public DataField(int id, String name, DataType type, @Nullable String description) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.description = description;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public DataType type() {
        return this.type;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataField field = (DataField)o;
        return Objects.equals(this.id, field.id) && Objects.equals(this.name, field.name) && Objects.equals(this.type, field.type) && Objects.equals(this.description, field.description);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.type, this.description);
    }

    public String toString() {
        return JsonSerdeUtil.toJson(this);
    }
}

