/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.predicate;

import java.util.List;
import java.util.Optional;
import org.apache.flink.table.store.file.predicate.CompareUtils;
import org.apache.flink.table.store.file.predicate.FieldRef;
import org.apache.flink.table.store.file.predicate.FunctionVisitor;
import org.apache.flink.table.store.file.predicate.LeafFunction;
import org.apache.flink.table.store.file.predicate.NotIn;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.types.logical.LogicalType;

public class In
extends LeafFunction {
    private static final long serialVersionUID = 1L;
    public static final In INSTANCE = new In();

    private In() {
    }

    @Override
    public boolean test(LogicalType type, Object field, List<Object> literals) {
        if (field == null) {
            return false;
        }
        for (Object literal : literals) {
            if (literal == null || CompareUtils.compareLiteral(type, literal, field) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean test(LogicalType type, long rowCount, FieldStats fieldStats, List<Object> literals) {
        if (rowCount == fieldStats.nullCount()) {
            return false;
        }
        for (Object literal : literals) {
            if (literal == null || CompareUtils.compareLiteral(type, literal, fieldStats.minValue()) < 0 || CompareUtils.compareLiteral(type, literal, fieldStats.maxValue()) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<LeafFunction> negate() {
        return Optional.of(NotIn.INSTANCE);
    }

    @Override
    public <T> T visit(FunctionVisitor<T> visitor, FieldRef fieldRef, List<Object> literals) {
        return visitor.visitIn(fieldRef, literals);
    }
}

