/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;

@Internal
public class CoFeedbackTransformation<F>
extends Transformation<F> {
    private final List<Transformation<F>> feedbackEdges;
    private final Long waitTime;

    public CoFeedbackTransformation(int parallelism, TypeInformation<F> feedbackType, Long waitTime) {
        super("CoFeedback", feedbackType, parallelism);
        this.waitTime = waitTime;
        this.feedbackEdges = Lists.newArrayList();
    }

    public void addFeedbackEdge(Transformation<F> transform) {
        if (transform.getParallelism() != this.getParallelism()) {
            throw new UnsupportedOperationException("Parallelism of the feedback stream must match the parallelism of the original stream. Parallelism of original stream: " + this.getParallelism() + "; parallelism of feedback stream: " + transform.getParallelism());
        }
        this.feedbackEdges.add(transform);
    }

    public List<Transformation<F>> getFeedbackEdges() {
        return this.feedbackEdges;
    }

    public Long getWaitTime() {
        return this.waitTime;
    }

    @Override
    public List<Transformation<?>> getTransitivePredecessors() {
        return Collections.singletonList(this);
    }

    @Override
    public List<Transformation<?>> getInputs() {
        return Collections.emptyList();
    }
}

