/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumerWithPartialRecordLength;
import org.apache.flink.runtime.io.network.logger.NetworkActionsLogger;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ChannelStateHolder;
import org.apache.flink.runtime.io.network.partition.CheckpointedResultSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.PrioritizedDeque;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.consumer.EndOfChannelStateEvent;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterators;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelinedSubpartition
extends ResultSubpartition
implements CheckpointedResultSubpartition,
ChannelStateHolder {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinedSubpartition.class);
    private final int receiverExclusiveBuffersPerChannel;
    final PrioritizedDeque<BufferConsumerWithPartialRecordLength> buffers = new PrioritizedDeque();
    @GuardedBy(value="buffers")
    private int buffersInBacklog;
    PipelinedSubpartitionView readView;
    private boolean isFinished;
    @GuardedBy(value="buffers")
    private boolean flushRequested;
    volatile boolean isReleased;
    private long totalNumberOfBuffers;
    private long totalNumberOfBytes;
    private ChannelStateWriter channelStateWriter;
    private int bufferSize = Integer.MAX_VALUE;
    @GuardedBy(value="buffers")
    boolean isBlocked = false;
    int sequenceNumber = 0;

    PipelinedSubpartition(int index, int receiverExclusiveBuffersPerChannel, ResultPartition parent) {
        super(index, parent);
        Preconditions.checkArgument(receiverExclusiveBuffersPerChannel >= 0, "Buffers per channel must be non-negative.");
        this.receiverExclusiveBuffersPerChannel = receiverExclusiveBuffersPerChannel;
    }

    @Override
    public void setChannelStateWriter(ChannelStateWriter channelStateWriter) {
        Preconditions.checkState(this.channelStateWriter == null, "Already initialized");
        this.channelStateWriter = Preconditions.checkNotNull(channelStateWriter);
    }

    @Override
    public int add(BufferConsumer bufferConsumer, int partialRecordLength) {
        return this.add(bufferConsumer, partialRecordLength, false);
    }

    @Override
    public void addRecovered(BufferConsumer bufferConsumer) throws IOException {
        NetworkActionsLogger.traceRecover("PipelinedSubpartition#addRecovered", bufferConsumer, this.parent.getOwningTaskName(), this.subpartitionInfo);
        if (this.add(bufferConsumer, Integer.MIN_VALUE) == -1) {
            throw new IOException("Buffer consumer couldn't be added to ResultSubpartition");
        }
    }

    @Override
    public void finishReadRecoveredState(boolean notifyAndBlockOnCompletion) throws IOException {
        if (notifyAndBlockOnCompletion) {
            this.add(EventSerializer.toBufferConsumer(EndOfChannelStateEvent.INSTANCE, false), 0, false);
        }
    }

    @Override
    public void finish() throws IOException {
        this.add(EventSerializer.toBufferConsumer(EndOfPartitionEvent.INSTANCE, false), 0, true);
        LOG.debug("{}: Finished {}.", (Object)this.parent.getOwningTaskName(), (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int add(BufferConsumer bufferConsumer, int partialRecordLength, boolean finish) {
        int newBufferSize;
        boolean notifyDataAvailable;
        Preconditions.checkNotNull(bufferConsumer);
        int prioritySequenceNumber = -1;
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            if (this.isFinished || this.isReleased) {
                bufferConsumer.close();
                return -1;
            }
            if (this.addBuffer(bufferConsumer, partialRecordLength)) {
                prioritySequenceNumber = this.sequenceNumber;
            }
            this.updateStatistics(bufferConsumer);
            this.increaseBuffersInBacklog(bufferConsumer);
            notifyDataAvailable = finish || this.shouldNotifyDataAvailable();
            this.isFinished |= finish;
            newBufferSize = this.bufferSize;
        }
        if (prioritySequenceNumber != -1) {
            this.notifyPriorityEvent(prioritySequenceNumber);
        }
        if (notifyDataAvailable) {
            this.notifyDataAvailable();
        }
        return newBufferSize;
    }

    private boolean addBuffer(BufferConsumer bufferConsumer, int partialRecordLength) {
        assert (Thread.holdsLock(this.buffers));
        if (bufferConsumer.getDataType().hasPriority()) {
            return this.processPriorityBuffer(bufferConsumer, partialRecordLength);
        }
        this.buffers.add(new BufferConsumerWithPartialRecordLength(bufferConsumer, partialRecordLength));
        return false;
    }

    private boolean processPriorityBuffer(BufferConsumer bufferConsumer, int partialRecordLength) {
        this.buffers.addPriorityElement(new BufferConsumerWithPartialRecordLength(bufferConsumer, partialRecordLength));
        int numPriorityElements = this.buffers.getNumPriorityElements();
        CheckpointBarrier barrier = this.parseCheckpointBarrier(bufferConsumer);
        if (barrier != null) {
            Preconditions.checkState(barrier.getCheckpointOptions().isUnalignedCheckpoint(), "Only unaligned checkpoints should be priority events");
            Iterator<BufferConsumerWithPartialRecordLength> iterator = this.buffers.iterator();
            Iterators.advance(iterator, numPriorityElements);
            ArrayList<Buffer> inflightBuffers = new ArrayList<Buffer>();
            while (iterator.hasNext()) {
                BufferConsumer buffer = iterator.next().getBufferConsumer();
                if (!buffer.isBuffer()) continue;
                BufferConsumer bc = buffer.copy();
                Throwable throwable = null;
                try {
                    inflightBuffers.add(bc.build());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bc == null) continue;
                    if (throwable != null) {
                        try {
                            bc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bc.close();
                }
            }
            if (!inflightBuffers.isEmpty()) {
                this.channelStateWriter.addOutputData(barrier.getId(), this.subpartitionInfo, -2, inflightBuffers.toArray(new Buffer[0]));
            }
        }
        return numPriorityElements == 1 && !this.isBlocked;
    }

    @Nullable
    private CheckpointBarrier parseCheckpointBarrier(BufferConsumer bufferConsumer) {
        CheckpointBarrier barrier;
        try (BufferConsumer bc = bufferConsumer.copy();){
            Buffer buffer = bc.build();
            try {
                AbstractEvent event = EventSerializer.fromBuffer(buffer, this.getClass().getClassLoader());
                barrier = event instanceof CheckpointBarrier ? (CheckpointBarrier)event : null;
            }
            catch (IOException e) {
                throw new IllegalStateException("Should always be able to deserialize in-memory event", e);
            }
            finally {
                buffer.recycleBuffer();
            }
        }
        return barrier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        PipelinedSubpartitionView view;
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            if (this.isReleased) {
                return;
            }
            for (BufferConsumerWithPartialRecordLength buffer : this.buffers) {
                buffer.getBufferConsumer().close();
            }
            this.buffers.clear();
            view = this.readView;
            this.readView = null;
            this.isReleased = true;
        }
        LOG.debug("{}: Released {}.", (Object)this.parent.getOwningTaskName(), (Object)this);
        if (view != null) {
            view.releaseAllResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ResultSubpartition.BufferAndBacklog pollBuffer() {
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            if (this.isBlocked) {
                return null;
            }
            Buffer buffer = null;
            if (this.buffers.isEmpty()) {
                this.flushRequested = false;
            }
            while (!this.buffers.isEmpty()) {
                BufferConsumerWithPartialRecordLength bufferConsumerWithPartialRecordLength = this.buffers.peek();
                BufferConsumer bufferConsumer = bufferConsumerWithPartialRecordLength.getBufferConsumer();
                buffer = this.buildSliceBuffer(bufferConsumerWithPartialRecordLength);
                Preconditions.checkState(bufferConsumer.isFinished() || this.buffers.size() == 1, "When there are multiple buffers, an unfinished bufferConsumer can not be at the head of the buffers queue.");
                if (this.buffers.size() == 1) {
                    this.flushRequested = false;
                }
                if (bufferConsumer.isFinished()) {
                    Objects.requireNonNull(this.buffers.poll()).getBufferConsumer().close();
                    this.decreaseBuffersInBacklogUnsafe(bufferConsumer.isBuffer());
                }
                if (this.receiverExclusiveBuffersPerChannel == 0 && bufferConsumer.isFinished() || buffer.readableBytes() > 0) break;
                buffer.recycleBuffer();
                buffer = null;
                if (bufferConsumer.isFinished()) continue;
                break;
            }
            if (buffer == null) {
                return null;
            }
            if (buffer.getDataType().isBlockingUpstream()) {
                this.isBlocked = true;
            }
            this.updateStatistics(buffer);
            NetworkActionsLogger.traceOutput("PipelinedSubpartition#pollBuffer", buffer, this.parent.getOwningTaskName(), this.subpartitionInfo);
            return new ResultSubpartition.BufferAndBacklog(buffer, this.getBuffersInBacklogUnsafe(), this.isDataAvailableUnsafe() ? this.getNextBufferTypeUnsafe() : Buffer.DataType.NONE, this.sequenceNumber++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeConsumption() {
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            Preconditions.checkState(this.isBlocked, "Should be blocked by checkpoint.");
            this.isBlocked = false;
        }
    }

    public void acknowledgeAllDataProcessed() {
        this.parent.onSubpartitionAllDataProcessed(this.subpartitionInfo.getSubPartitionIdx());
    }

    @Override
    public boolean isReleased() {
        return this.isReleased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PipelinedSubpartitionView createReadView(BufferAvailabilityListener availabilityListener) {
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            Preconditions.checkState(!this.isReleased);
            Preconditions.checkState(this.readView == null, "Subpartition %s of is being (or already has been) consumed, but pipelined subpartitions can only be consumed once.", this.getSubPartitionIndex(), this.parent.getPartitionId());
            LOG.debug("{}: Creating read view for subpartition {} of partition {}.", new Object[]{this.parent.getOwningTaskName(), this.getSubPartitionIndex(), this.parent.getPartitionId()});
            this.readView = new PipelinedSubpartitionView(this, availabilityListener);
        }
        return this.readView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSubpartitionView.AvailabilityWithBacklog getAvailabilityAndBacklog(int numCreditsAvailable) {
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            boolean isAvailable = numCreditsAvailable > 0 ? this.isDataAvailableUnsafe() : this.getNextBufferTypeUnsafe().isEvent();
            return new ResultSubpartitionView.AvailabilityWithBacklog(isAvailable, this.getBuffersInBacklogUnsafe());
        }
    }

    @GuardedBy(value="buffers")
    private boolean isDataAvailableUnsafe() {
        assert (Thread.holdsLock(this.buffers));
        return !this.isBlocked && (this.flushRequested || this.getNumberOfFinishedBuffers() > 0);
    }

    private Buffer.DataType getNextBufferTypeUnsafe() {
        assert (Thread.holdsLock(this.buffers));
        BufferConsumerWithPartialRecordLength first = this.buffers.peek();
        return first != null ? first.getBufferConsumer().getDataType() : Buffer.DataType.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfQueuedBuffers() {
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            return this.buffers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bufferSize(int desirableNewBufferSize) {
        if (desirableNewBufferSize < 0) {
            throw new IllegalArgumentException("New buffer size can not be less than zero");
        }
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            this.bufferSize = desirableNewBufferSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean hasReadView;
        boolean finished;
        long numBytes;
        long numBuffers;
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            numBuffers = this.getTotalNumberOfBuffersUnsafe();
            numBytes = this.getTotalNumberOfBytesUnsafe();
            finished = this.isFinished;
            hasReadView = this.readView != null;
        }
        return String.format("%s#%d [number of buffers: %d (%d bytes), number of buffers in backlog: %d, finished? %s, read view? %s]", this.getClass().getSimpleName(), this.getSubPartitionIndex(), numBuffers, numBytes, this.getBuffersInBacklogUnsafe(), finished, hasReadView);
    }

    @Override
    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return Math.max(this.buffers.size(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        boolean notifyDataAvailable;
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            if (this.buffers.isEmpty() || this.flushRequested) {
                return;
            }
            boolean isDataAvailableInUnfinishedBuffer = this.buffers.size() == 1 && this.buffers.peek().getBufferConsumer().isDataAvailable();
            notifyDataAvailable = !this.isBlocked && isDataAvailableInUnfinishedBuffer;
            this.flushRequested = this.buffers.size() > 1 || isDataAvailableInUnfinishedBuffer;
        }
        if (notifyDataAvailable) {
            this.notifyDataAvailable();
        }
    }

    @Override
    protected long getTotalNumberOfBuffersUnsafe() {
        return this.totalNumberOfBuffers;
    }

    @Override
    protected long getTotalNumberOfBytesUnsafe() {
        return this.totalNumberOfBytes;
    }

    Throwable getFailureCause() {
        return this.parent.getFailureCause();
    }

    private void updateStatistics(BufferConsumer buffer) {
        ++this.totalNumberOfBuffers;
    }

    private void updateStatistics(Buffer buffer) {
        this.totalNumberOfBytes += (long)buffer.getSize();
    }

    @GuardedBy(value="buffers")
    private void decreaseBuffersInBacklogUnsafe(boolean isBuffer) {
        assert (Thread.holdsLock(this.buffers));
        if (isBuffer) {
            --this.buffersInBacklog;
        }
    }

    @GuardedBy(value="buffers")
    private void increaseBuffersInBacklog(BufferConsumer buffer) {
        assert (Thread.holdsLock(this.buffers));
        if (buffer != null && buffer.isBuffer()) {
            ++this.buffersInBacklog;
        }
    }

    @Override
    public int getBuffersInBacklogUnsafe() {
        if (this.isBlocked || this.buffers.isEmpty()) {
            return 0;
        }
        if (this.flushRequested || this.isFinished || !Preconditions.checkNotNull(this.buffers.peekLast()).getBufferConsumer().isBuffer()) {
            return this.buffersInBacklog;
        }
        return Math.max(this.buffersInBacklog - 1, 0);
    }

    @GuardedBy(value="buffers")
    private boolean shouldNotifyDataAvailable() {
        return this.readView != null && !this.flushRequested && !this.isBlocked && this.getNumberOfFinishedBuffers() == 1;
    }

    private void notifyDataAvailable() {
        PipelinedSubpartitionView readView = this.readView;
        if (readView != null) {
            readView.notifyDataAvailable();
        }
    }

    private void notifyPriorityEvent(int prioritySequenceNumber) {
        PipelinedSubpartitionView readView = this.readView;
        if (readView != null) {
            readView.notifyPriorityEvent(prioritySequenceNumber);
        }
    }

    private int getNumberOfFinishedBuffers() {
        assert (Thread.holdsLock(this.buffers));
        int numBuffers = this.buffers.size();
        if (numBuffers == 1 && this.buffers.peekLast().getBufferConsumer().isFinished()) {
            return 1;
        }
        return Math.max(0, numBuffers - 1);
    }

    @Override
    public BufferBuilder requestBufferBuilderBlocking() throws InterruptedException {
        return this.parent.getBufferPool().requestBufferBuilderBlocking();
    }

    Buffer buildSliceBuffer(BufferConsumerWithPartialRecordLength buffer) {
        return buffer.build();
    }

    @VisibleForTesting
    BufferConsumerWithPartialRecordLength getNextBuffer() {
        return this.buffers.poll();
    }
}

