/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.runtime.dispatcher.runner.AbstractDispatcherLeaderProcess;
import org.apache.flink.runtime.dispatcher.runner.DispatcherLeaderProcess;
import org.apache.flink.runtime.dispatcher.runner.DispatcherLeaderProcessFactory;
import org.apache.flink.runtime.dispatcher.runner.JobDispatcherLeaderProcess;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.Preconditions;

public class JobDispatcherLeaderProcessFactory
implements DispatcherLeaderProcessFactory {
    private final AbstractDispatcherLeaderProcess.DispatcherGatewayServiceFactory dispatcherGatewayServiceFactory;
    @Nullable
    private final JobGraph jobGraph;
    @Nullable
    private final JobResult recoveredDirtyJobResult;
    private final JobResultStore jobResultStore;
    private final FatalErrorHandler fatalErrorHandler;

    JobDispatcherLeaderProcessFactory(AbstractDispatcherLeaderProcess.DispatcherGatewayServiceFactory dispatcherGatewayServiceFactory, @Nullable JobGraph jobGraph, @Nullable JobResult recoveredDirtyJobResult, JobResultStore jobResultStore, FatalErrorHandler fatalErrorHandler) {
        this.dispatcherGatewayServiceFactory = dispatcherGatewayServiceFactory;
        this.jobGraph = jobGraph;
        this.recoveredDirtyJobResult = recoveredDirtyJobResult;
        this.jobResultStore = Preconditions.checkNotNull(jobResultStore);
        this.fatalErrorHandler = fatalErrorHandler;
    }

    @Override
    public DispatcherLeaderProcess create(UUID leaderSessionID) {
        return new JobDispatcherLeaderProcess(leaderSessionID, this.dispatcherGatewayServiceFactory, this.jobGraph, this.recoveredDirtyJobResult, this.jobResultStore, this.fatalErrorHandler);
    }

    @Nullable
    JobGraph getJobGraph() {
        return this.jobGraph;
    }

    @Nullable
    JobResult getRecoveredDirtyJobResult() {
        return this.recoveredDirtyJobResult;
    }
}

