/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.Preconditions;

public class RegisteredKeyValueStateBackendMetaInfo<N, S>
extends RegisteredStateMetaInfoBase {
    @Nonnull
    private final StateDescriptor.Type stateType;
    @Nonnull
    private final StateSerializerProvider<N> namespaceSerializerProvider;
    @Nonnull
    private final StateSerializerProvider<S> stateSerializerProvider;
    @Nonnull
    private StateSnapshotTransformer.StateSnapshotTransformFactory<S> stateSnapshotTransformFactory;

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull StateDescriptor.Type stateType, @Nonnull String name, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull TypeSerializer<S> stateSerializer) {
        this(stateType, name, StateSerializerProvider.fromNewRegisteredSerializer(namespaceSerializer), StateSerializerProvider.fromNewRegisteredSerializer(stateSerializer), StateSnapshotTransformer.StateSnapshotTransformFactory.noTransform());
    }

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull StateDescriptor.Type stateType, @Nonnull String name, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull TypeSerializer<S> stateSerializer, @Nonnull StateSnapshotTransformer.StateSnapshotTransformFactory<S> stateSnapshotTransformFactory) {
        this(stateType, name, StateSerializerProvider.fromNewRegisteredSerializer(namespaceSerializer), StateSerializerProvider.fromNewRegisteredSerializer(stateSerializer), stateSnapshotTransformFactory);
    }

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull StateMetaInfoSnapshot snapshot) {
        this(StateDescriptor.Type.valueOf(snapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE)), snapshot.getName(), StateSerializerProvider.fromPreviousSerializerSnapshot(Preconditions.checkNotNull(snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER))), StateSerializerProvider.fromPreviousSerializerSnapshot(Preconditions.checkNotNull(snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER))), StateSnapshotTransformer.StateSnapshotTransformFactory.noTransform());
        Preconditions.checkState(StateMetaInfoSnapshot.BackendStateType.KEY_VALUE == snapshot.getBackendStateType());
    }

    private RegisteredKeyValueStateBackendMetaInfo(@Nonnull StateDescriptor.Type stateType, @Nonnull String name, @Nonnull StateSerializerProvider<N> namespaceSerializerProvider, @Nonnull StateSerializerProvider<S> stateSerializerProvider, @Nonnull StateSnapshotTransformer.StateSnapshotTransformFactory<S> stateSnapshotTransformFactory) {
        super(name);
        this.stateType = stateType;
        this.namespaceSerializerProvider = namespaceSerializerProvider;
        this.stateSerializerProvider = stateSerializerProvider;
        this.stateSnapshotTransformFactory = stateSnapshotTransformFactory;
    }

    @Nonnull
    public StateDescriptor.Type getStateType() {
        return this.stateType;
    }

    @Nonnull
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializerProvider.currentSchemaSerializer();
    }

    @Nonnull
    public TypeSerializerSchemaCompatibility<N> updateNamespaceSerializer(TypeSerializer<N> newNamespaceSerializer) {
        return this.namespaceSerializerProvider.registerNewSerializerForRestoredState(newNamespaceSerializer);
    }

    @Nonnull
    public TypeSerializer<N> getPreviousNamespaceSerializer() {
        return this.namespaceSerializerProvider.previousSchemaSerializer();
    }

    @Nonnull
    public TypeSerializer<S> getStateSerializer() {
        return this.stateSerializerProvider.currentSchemaSerializer();
    }

    @Nonnull
    public TypeSerializerSchemaCompatibility<S> updateStateSerializer(TypeSerializer<S> newStateSerializer) {
        return this.stateSerializerProvider.registerNewSerializerForRestoredState(newStateSerializer);
    }

    @Nonnull
    public TypeSerializer<S> getPreviousStateSerializer() {
        return this.stateSerializerProvider.previousSchemaSerializer();
    }

    @Nullable
    public TypeSerializerSnapshot<S> getPreviousStateSerializerSnapshot() {
        return this.stateSerializerProvider.previousSerializerSnapshot;
    }

    @Nonnull
    public StateSnapshotTransformer.StateSnapshotTransformFactory<S> getStateSnapshotTransformFactory() {
        return this.stateSnapshotTransformFactory;
    }

    public void updateSnapshotTransformFactory(StateSnapshotTransformer.StateSnapshotTransformFactory<S> stateSnapshotTransformFactory) {
        this.stateSnapshotTransformFactory = stateSnapshotTransformFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredKeyValueStateBackendMetaInfo that = (RegisteredKeyValueStateBackendMetaInfo)o;
        if (!this.stateType.equals((Object)that.stateType)) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getStateSerializer().equals(that.getStateSerializer()) && this.getNamespaceSerializer().equals(that.getNamespaceSerializer());
    }

    public String toString() {
        return "RegisteredKeyedBackendStateMetaInfo{stateType=" + (Object)((Object)this.stateType) + ", name='" + this.name + '\'' + ", namespaceSerializer=" + this.getNamespaceSerializer() + ", stateSerializer=" + this.getStateSerializer() + '}';
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getStateType().hashCode();
        result = 31 * result + this.getNamespaceSerializer().hashCode();
        result = 31 * result + this.getStateSerializer().hashCode();
        return result;
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot snapshot() {
        return this.computeSnapshot();
    }

    public void checkStateMetaInfo(StateDescriptor<?, ?> stateDesc) {
        Preconditions.checkState(Objects.equals(stateDesc.getName(), this.getName()), "Incompatible state names. Was [" + this.getName() + "], registered with [" + stateDesc.getName() + "].");
        if (stateDesc.getType() != StateDescriptor.Type.UNKNOWN && this.getStateType() != StateDescriptor.Type.UNKNOWN) {
            Preconditions.checkState(stateDesc.getType() == this.getStateType(), "Incompatible key/value state types. Was [" + (Object)((Object)this.getStateType()) + "], registered with [" + (Object)((Object)stateDesc.getType()) + "].");
        }
    }

    @Nonnull
    private StateMetaInfoSnapshot computeSnapshot() {
        Map<String, String> optionsMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE.toString(), this.stateType.toString());
        HashMap serializerMap = new HashMap(2);
        HashMap serializerConfigSnapshotsMap = new HashMap(2);
        String namespaceSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER.toString();
        String valueSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString();
        TypeSerializer<N> namespaceSerializer = this.getNamespaceSerializer();
        serializerMap.put(namespaceSerializerKey, namespaceSerializer.duplicate());
        serializerConfigSnapshotsMap.put(namespaceSerializerKey, namespaceSerializer.snapshotConfiguration());
        TypeSerializer<S> stateSerializer = this.getStateSerializer();
        serializerMap.put(valueSerializerKey, stateSerializer.duplicate());
        serializerConfigSnapshotsMap.put(valueSerializerKey, stateSerializer.snapshotConfiguration());
        return new StateMetaInfoSnapshot(this.name, StateMetaInfoSnapshot.BackendStateType.KEY_VALUE, optionsMap, serializerConfigSnapshotsMap, serializerMap);
    }
}

