/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.avro.shaded.org.apache.avro.LogicalType;
import org.apache.flink.avro.shaded.org.apache.avro.LogicalTypes;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.SchemaParseException;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericDatumWriter;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericRecord;
import org.apache.flink.avro.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.flink.avro.shaded.org.apache.avro.io.DatumWriter;
import org.apache.flink.avro.shaded.org.apache.avro.io.Encoder;
import org.apache.flink.avro.shaded.org.apache.avro.io.EncoderFactory;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificData;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificDatumWriter;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificRecord;
import org.apache.flink.avro.shaded.org.apache.avro.util.Utf8;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@Deprecated
public class AvroRowSerializationSchema
implements SerializationSchema<Row> {
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    private Class<? extends SpecificRecord> recordClazz;
    private String schemaString;
    private transient Schema schema;
    private transient DatumWriter<IndexedRecord> datumWriter;
    private transient ByteArrayOutputStream arrayOutputStream;
    private transient Encoder encoder;

    public AvroRowSerializationSchema(Class<? extends SpecificRecord> recordClazz) {
        Preconditions.checkNotNull(recordClazz, "Avro record class must not be null.");
        this.recordClazz = recordClazz;
        this.schema = SpecificData.get().getSchema(recordClazz);
        this.schemaString = this.schema.toString();
        this.datumWriter = new SpecificDatumWriter<IndexedRecord>(this.schema);
        this.arrayOutputStream = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder(this.arrayOutputStream, null);
    }

    public AvroRowSerializationSchema(String avroSchemaString) {
        Preconditions.checkNotNull(avroSchemaString, "Avro schema must not be null.");
        this.recordClazz = null;
        this.schemaString = avroSchemaString;
        try {
            this.schema = new Schema.Parser().parse(avroSchemaString);
        }
        catch (SchemaParseException e) {
            throw new IllegalArgumentException("Could not parse Avro schema string.", e);
        }
        this.datumWriter = new GenericDatumWriter<IndexedRecord>(this.schema);
        this.arrayOutputStream = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder(this.arrayOutputStream, null);
    }

    @Override
    public byte[] serialize(Row row) {
        try {
            GenericRecord record = this.convertRowToAvroRecord(this.schema, row);
            this.arrayOutputStream.reset();
            this.datumWriter.write(record, this.encoder);
            this.encoder.flush();
            return this.arrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize row.", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroRowSerializationSchema that = (AvroRowSerializationSchema)o;
        return Objects.equals(this.recordClazz, that.recordClazz) && Objects.equals(this.schemaString, that.schemaString);
    }

    public int hashCode() {
        return Objects.hash(this.recordClazz, this.schemaString);
    }

    private GenericRecord convertRowToAvroRecord(Schema schema, Row row) {
        List<Schema.Field> fields = schema.getFields();
        int length = fields.size();
        GenericData.Record record = new GenericData.Record(schema);
        for (int i = 0; i < length; ++i) {
            Schema.Field field = fields.get(i);
            record.put(i, this.convertFlinkType(field.schema(), row.getField(i)));
        }
        return record;
    }

    private Object convertFlinkType(Schema schema, Object object) {
        if (object == null) {
            return null;
        }
        switch (schema.getType()) {
            case RECORD: {
                if (object instanceof Row) {
                    return this.convertRowToAvroRecord(schema, (Row)object);
                }
                throw new IllegalStateException("Row expected but was: " + object.getClass());
            }
            case ENUM: {
                return new GenericData.EnumSymbol(schema, object.toString());
            }
            case ARRAY: {
                Schema elementSchema = schema.getElementType();
                Object[] array = (Object[])object;
                GenericData.Array convertedArray = new GenericData.Array(array.length, schema);
                for (Object element : array) {
                    convertedArray.add(this.convertFlinkType(elementSchema, element));
                }
                return convertedArray;
            }
            case MAP: {
                Map map = (Map)object;
                HashMap<Utf8, Object> convertedMap = new HashMap<Utf8, Object>();
                for (Map.Entry entry : map.entrySet()) {
                    convertedMap.put(new Utf8(entry.getKey().toString()), this.convertFlinkType(schema.getValueType(), entry.getValue()));
                }
                return convertedMap;
            }
            case UNION: {
                Schema actualSchema;
                List<Schema> types = schema.getTypes();
                int size = types.size();
                if (size == 2 && types.get(0).getType() == Schema.Type.NULL) {
                    actualSchema = types.get(1);
                } else if (size == 2 && types.get(1).getType() == Schema.Type.NULL) {
                    actualSchema = types.get(0);
                } else if (size == 1) {
                    actualSchema = types.get(0);
                } else {
                    return object;
                }
                return this.convertFlinkType(actualSchema, object);
            }
            case FIXED: {
                if (object instanceof BigDecimal) {
                    return new GenericData.Fixed(schema, this.convertFromDecimal(schema, (BigDecimal)object));
                }
                return new GenericData.Fixed(schema, (byte[])object);
            }
            case STRING: {
                return new Utf8(object.toString());
            }
            case BYTES: {
                if (object instanceof BigDecimal) {
                    return ByteBuffer.wrap(this.convertFromDecimal(schema, (BigDecimal)object));
                }
                return ByteBuffer.wrap((byte[])object);
            }
            case INT: {
                if (object instanceof Date) {
                    return this.convertFromDate(schema, (Date)object);
                }
                if (object instanceof LocalDate) {
                    return this.convertFromDate(schema, Date.valueOf((LocalDate)object));
                }
                if (object instanceof Time) {
                    return this.convertFromTimeMillis(schema, (Time)object);
                }
                if (object instanceof LocalTime) {
                    return this.convertFromTimeMillis(schema, Time.valueOf((LocalTime)object));
                }
                return object;
            }
            case LONG: {
                if (object instanceof Timestamp) {
                    return this.convertFromTimestamp(schema, (Timestamp)object);
                }
                if (object instanceof LocalDateTime) {
                    return this.convertFromTimestamp(schema, Timestamp.valueOf((LocalDateTime)object));
                }
                if (object instanceof Time) {
                    return this.convertFromTimeMicros(schema, (Time)object);
                }
                return object;
            }
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return object;
            }
        }
        throw new RuntimeException("Unsupported Avro type:" + schema);
    }

    private byte[] convertFromDecimal(Schema schema, BigDecimal decimal) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType instanceof LogicalTypes.Decimal) {
            LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)logicalType;
            BigDecimal rescaled = decimal.setScale(decimalType.getScale(), 7);
            return decimal.unscaledValue().toByteArray();
        }
        throw new RuntimeException("Unsupported decimal type.");
    }

    private int convertFromDate(Schema schema, Date date) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType == LogicalTypes.date()) {
            long converted = this.toEpochMillis(date);
            return (int)(converted / 86400000L);
        }
        throw new RuntimeException("Unsupported date type.");
    }

    private int convertFromTimeMillis(Schema schema, Time date) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType == LogicalTypes.timeMillis()) {
            long converted = this.toEpochMillis(date);
            return (int)(converted % 86400000L);
        }
        throw new RuntimeException("Unsupported time type.");
    }

    private long convertFromTimeMicros(Schema schema, Time date) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType == LogicalTypes.timeMicros()) {
            long converted = this.toEpochMillis(date);
            return converted % 86400000L * 1000L;
        }
        throw new RuntimeException("Unsupported time type.");
    }

    private long convertFromTimestamp(Schema schema, Timestamp date) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType == LogicalTypes.timestampMillis()) {
            long time = date.getTime();
            return time + (long)LOCAL_TZ.getOffset(time);
        }
        if (logicalType == LogicalTypes.timestampMicros()) {
            long millis = date.getTime();
            long micros = millis * 1000L + (long)(date.getNanos() % 1000000 / 1000);
            long offset = (long)LOCAL_TZ.getOffset(millis) * 1000L;
            return micros + offset;
        }
        throw new RuntimeException("Unsupported timestamp type.");
    }

    private long toEpochMillis(java.util.Date date) {
        long time = date.getTime();
        return time + (long)LOCAL_TZ.getOffset(time);
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.writeObject(this.recordClazz);
        outputStream.writeObject(this.schemaString);
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        this.recordClazz = (Class)inputStream.readObject();
        this.schemaString = (String)inputStream.readObject();
        this.schema = this.recordClazz != null ? SpecificData.get().getSchema(this.recordClazz) : new Schema.Parser().parse(this.schemaString);
        this.datumWriter = new SpecificDatumWriter<IndexedRecord>(this.schema);
        this.arrayOutputStream = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder(this.arrayOutputStream, null);
    }
}

