/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public abstract class RetryingRegistration<F extends Serializable, G extends RpcGateway, S extends RegistrationResponse.Success, R extends RegistrationResponse.Rejection> {
    private final Logger log;
    private final RpcService rpcService;
    private final String targetName;
    private final Class<G> targetType;
    private final String targetAddress;
    private final F fencingToken;
    private final CompletableFuture<RetryingRegistrationResult<G, S, R>> completionFuture;
    private final RetryingRegistrationConfiguration retryingRegistrationConfiguration;
    private volatile boolean canceled;

    public RetryingRegistration(Logger log, RpcService rpcService, String targetName, Class<G> targetType, String targetAddress, F fencingToken, RetryingRegistrationConfiguration retryingRegistrationConfiguration) {
        this.log = Preconditions.checkNotNull(log);
        this.rpcService = Preconditions.checkNotNull(rpcService);
        this.targetName = Preconditions.checkNotNull(targetName);
        this.targetType = Preconditions.checkNotNull(targetType);
        this.targetAddress = Preconditions.checkNotNull(targetAddress);
        this.fencingToken = (Serializable)Preconditions.checkNotNull(fencingToken);
        this.retryingRegistrationConfiguration = Preconditions.checkNotNull(retryingRegistrationConfiguration);
        this.completionFuture = new CompletableFuture();
    }

    public CompletableFuture<RetryingRegistrationResult<G, S, R>> getFuture() {
        return this.completionFuture;
    }

    public void cancel() {
        this.canceled = true;
        this.completionFuture.cancel(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected abstract CompletableFuture<RegistrationResponse> invokeRegistration(G var1, F var2, long var3) throws Exception;

    public void startRegistration() {
        if (this.canceled) {
            return;
        }
        try {
            CompletableFuture rpcGatewayFuture = FencedRpcGateway.class.isAssignableFrom(this.targetType) ? this.rpcService.connect(this.targetAddress, this.fencingToken, this.targetType.asSubclass(FencedRpcGateway.class)) : this.rpcService.connect(this.targetAddress, this.targetType);
            CompletionStage rpcGatewayAcceptFuture = rpcGatewayFuture.thenAcceptAsync(rpcGateway -> {
                this.log.info("Resolved {} address, beginning registration", (Object)this.targetName);
                this.register(rpcGateway, 1, this.retryingRegistrationConfiguration.getInitialRegistrationTimeoutMillis());
            }, (Executor)this.rpcService.getScheduledExecutor());
            ((CompletableFuture)rpcGatewayAcceptFuture).whenCompleteAsync((v, failure) -> {
                if (failure != null && !this.canceled) {
                    Throwable strippedFailure = ExceptionUtils.stripCompletionException(failure);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Could not resolve {} address {}, retrying in {} ms.", new Object[]{this.targetName, this.targetAddress, this.retryingRegistrationConfiguration.getErrorDelayMillis(), strippedFailure});
                    } else {
                        this.log.info("Could not resolve {} address {}, retrying in {} ms: {}", new Object[]{this.targetName, this.targetAddress, this.retryingRegistrationConfiguration.getErrorDelayMillis(), strippedFailure.getMessage()});
                    }
                    this.startRegistrationLater(this.retryingRegistrationConfiguration.getErrorDelayMillis());
                }
            }, (Executor)this.rpcService.getScheduledExecutor());
        }
        catch (Throwable t) {
            this.completionFuture.completeExceptionally(t);
            this.cancel();
        }
    }

    private void register(G gateway, int attempt, long timeoutMillis) {
        if (this.canceled) {
            return;
        }
        try {
            this.log.debug("Registration at {} attempt {} (timeout={}ms)", new Object[]{this.targetName, attempt, timeoutMillis});
            CompletableFuture<RegistrationResponse> registrationFuture = this.invokeRegistration(gateway, this.fencingToken, timeoutMillis);
            CompletionStage registrationAcceptFuture = registrationFuture.thenAcceptAsync(result -> {
                if (!this.isCanceled()) {
                    if (result instanceof RegistrationResponse.Success) {
                        this.log.debug("Registration with {} at {} was successful.", (Object)this.targetName, (Object)this.targetAddress);
                        RegistrationResponse.Success success = (RegistrationResponse.Success)result;
                        this.completionFuture.complete(RetryingRegistrationResult.success(gateway, success));
                    } else if (result instanceof RegistrationResponse.Rejection) {
                        this.log.debug("Registration with {} at {} was rejected.", (Object)this.targetName, (Object)this.targetAddress);
                        RegistrationResponse.Rejection rejection = (RegistrationResponse.Rejection)result;
                        this.completionFuture.complete(RetryingRegistrationResult.rejection(rejection));
                    } else {
                        if (result instanceof RegistrationResponse.Failure) {
                            RegistrationResponse.Failure failure = (RegistrationResponse.Failure)result;
                            this.log.info("Registration failure at {} occurred.", (Object)this.targetName, (Object)failure.getReason());
                        } else {
                            this.log.error("Received unknown response to registration attempt: {}", result);
                        }
                        this.log.info("Pausing and re-attempting registration in {} ms", (Object)this.retryingRegistrationConfiguration.getRefusedDelayMillis());
                        this.registerLater(gateway, 1, this.retryingRegistrationConfiguration.getInitialRegistrationTimeoutMillis(), this.retryingRegistrationConfiguration.getRefusedDelayMillis());
                    }
                }
            }, (Executor)this.rpcService.getScheduledExecutor());
            ((CompletableFuture)registrationAcceptFuture).whenCompleteAsync((v, failure) -> {
                if (failure != null && !this.isCanceled()) {
                    if (ExceptionUtils.stripCompletionException(failure) instanceof TimeoutException) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Registration at {} ({}) attempt {} timed out after {} ms", new Object[]{this.targetName, this.targetAddress, attempt, timeoutMillis});
                        }
                        long newTimeoutMillis = Math.min(2L * timeoutMillis, this.retryingRegistrationConfiguration.getMaxRegistrationTimeoutMillis());
                        this.register(gateway, attempt + 1, newTimeoutMillis);
                    } else {
                        this.log.error("Registration at {} failed due to an error", (Object)this.targetName, failure);
                        this.log.info("Pausing and re-attempting registration in {} ms", (Object)this.retryingRegistrationConfiguration.getErrorDelayMillis());
                        this.registerLater(gateway, 1, this.retryingRegistrationConfiguration.getInitialRegistrationTimeoutMillis(), this.retryingRegistrationConfiguration.getErrorDelayMillis());
                    }
                }
            }, (Executor)this.rpcService.getScheduledExecutor());
        }
        catch (Throwable t) {
            this.completionFuture.completeExceptionally(t);
            this.cancel();
        }
    }

    private void registerLater(G gateway, int attempt, long timeoutMillis, long delay) {
        this.rpcService.scheduleRunnable(new Runnable((RpcGateway)gateway, attempt, timeoutMillis){
            final /* synthetic */ RpcGateway val$gateway;
            final /* synthetic */ int val$attempt;
            final /* synthetic */ long val$timeoutMillis;
            {
                this.val$gateway = rpcGateway;
                this.val$attempt = n;
                this.val$timeoutMillis = l;
            }

            @Override
            public void run() {
                RetryingRegistration.this.register(this.val$gateway, this.val$attempt, this.val$timeoutMillis);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    private void startRegistrationLater(long delay) {
        this.rpcService.scheduleRunnable(this::startRegistration, delay, TimeUnit.MILLISECONDS);
    }

    static final class RetryingRegistrationResult<G, S, R> {
        @Nullable
        private final G gateway;
        @Nullable
        private final S success;
        @Nullable
        private final R rejection;

        private RetryingRegistrationResult(@Nullable G gateway, @Nullable S success, @Nullable R rejection) {
            this.gateway = gateway;
            this.success = success;
            this.rejection = rejection;
        }

        boolean isSuccess() {
            return this.success != null && this.gateway != null;
        }

        boolean isRejection() {
            return this.rejection != null;
        }

        public G getGateway() {
            Preconditions.checkState(this.isSuccess());
            return this.gateway;
        }

        public R getRejection() {
            Preconditions.checkState(this.isRejection());
            return this.rejection;
        }

        public S getSuccess() {
            Preconditions.checkState(this.isSuccess());
            return this.success;
        }

        static <G extends RpcGateway, S extends RegistrationResponse.Success, R extends RegistrationResponse.Rejection> RetryingRegistrationResult<G, S, R> success(G gateway, S success) {
            return new RetryingRegistrationResult<G, S, Object>(gateway, success, null);
        }

        static <G extends RpcGateway, S extends RegistrationResponse.Success, R extends RegistrationResponse.Rejection> RetryingRegistrationResult<G, S, R> rejection(R rejection) {
            return new RetryingRegistrationResult<Object, Object, R>(null, null, rejection);
        }
    }
}

