/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ShowOperation;

public class ShowPartitionsOperation
implements ShowOperation {
    protected final ObjectIdentifier tableIdentifier;
    private final CatalogPartitionSpec partitionSpec;

    public ShowPartitionsOperation(ObjectIdentifier tableIdentifier, CatalogPartitionSpec partitionSpec) {
        this.tableIdentifier = tableIdentifier;
        this.partitionSpec = partitionSpec;
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public CatalogPartitionSpec getPartitionSpec() {
        return this.partitionSpec;
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder(String.format("SHOW PARTITIONS %s", this.tableIdentifier.asSummaryString()));
        if (this.partitionSpec != null) {
            builder.append(String.format(" PARTITION (%s)", OperationUtils.formatPartitionSpec(this.partitionSpec)));
        }
        return builder.toString();
    }
}

