/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.memory.sort;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.SimpleCollectingOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.sort.BinaryIndexedSortable;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.MemorySegmentPool;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.Preconditions;

public class BinaryInMemorySortBuffer
extends BinaryIndexedSortable {
    private static final int MIN_REQUIRED_BUFFERS = 3;
    private final AbstractRowDataSerializer<RowData> inputSerializer;
    private final ArrayList<MemorySegment> recordBufferSegments;
    private final SimpleCollectingOutputView recordCollector;
    private long currentDataBufferOffset;
    private long sortIndexBytes;
    private boolean isInitialized;

    public static BinaryInMemorySortBuffer createBuffer(NormalizedKeyComputer normalizedKeyComputer, AbstractRowDataSerializer<RowData> inputSerializer, BinaryRowDataSerializer serializer, RecordComparator comparator, MemorySegmentPool memoryPool) {
        Preconditions.checkArgument(memoryPool.freePages() >= 3);
        ArrayList<MemorySegment> recordBufferSegments = new ArrayList<MemorySegment>(16);
        return new BinaryInMemorySortBuffer(normalizedKeyComputer, inputSerializer, serializer, comparator, recordBufferSegments, new SimpleCollectingOutputView(recordBufferSegments, memoryPool, memoryPool.pageSize()), memoryPool);
    }

    private BinaryInMemorySortBuffer(NormalizedKeyComputer normalizedKeyComputer, AbstractRowDataSerializer<RowData> inputSerializer, BinaryRowDataSerializer serializer, RecordComparator comparator, ArrayList<MemorySegment> recordBufferSegments, SimpleCollectingOutputView recordCollector, MemorySegmentPool pool) {
        super(normalizedKeyComputer, serializer, comparator, recordBufferSegments, pool);
        this.inputSerializer = inputSerializer;
        this.recordBufferSegments = recordBufferSegments;
        this.recordCollector = recordCollector;
        this.isInitialized = true;
        this.clear();
    }

    public void returnToSegmentPool() {
        this.memorySegmentPool.returnAll(this.sortIndex);
        this.memorySegmentPool.returnAll(this.recordBufferSegments);
        this.sortIndex.clear();
        this.recordBufferSegments.clear();
    }

    public int getBufferSegmentCount() {
        return this.recordBufferSegments.size();
    }

    public void tryInitialize() {
        if (!this.isInitialized) {
            this.currentSortIndexSegment = this.nextMemorySegment();
            this.sortIndex.add(this.currentSortIndexSegment);
            this.recordCollector.reset();
            this.isInitialized = true;
        }
    }

    public void clear() {
        if (this.isInitialized) {
            this.numRecords = 0;
            this.currentSortIndexOffset = 0;
            this.currentDataBufferOffset = 0L;
            this.sortIndexBytes = 0L;
            this.returnToSegmentPool();
            this.currentSortIndexSegment = null;
            this.isInitialized = false;
        }
    }

    public long getOccupancy() {
        return this.currentDataBufferOffset + this.sortIndexBytes;
    }

    public boolean write(RowData record) throws IOException {
        int skip;
        this.tryInitialize();
        if (!this.checkNextIndexOffset()) {
            return false;
        }
        try {
            skip = this.inputSerializer.serializeToPages(record, this.recordCollector);
        }
        catch (EOFException e) {
            return false;
        }
        long newOffset = this.recordCollector.getCurrentOffset();
        long currOffset = this.currentDataBufferOffset + (long)skip;
        this.writeIndexAndNormalizedKey(record, currOffset);
        this.currentDataBufferOffset = newOffset;
        return true;
    }

    private BinaryRowData getRecordFromBuffer(BinaryRowData reuse, long pointer) throws IOException {
        this.recordBuffer.setReadPosition(pointer);
        return this.serializer.mapFromPages(reuse, (AbstractPagedInputView)this.recordBuffer);
    }

    public final MutableObjectIterator<BinaryRowData> getIterator() {
        this.tryInitialize();
        return new MutableObjectIterator<BinaryRowData>(){
            private final int size;
            private int current;
            private int currentSegment;
            private int currentOffset;
            private MemorySegment currentIndexSegment;
            {
                this.size = BinaryInMemorySortBuffer.this.size();
                this.current = 0;
                this.currentSegment = 0;
                this.currentOffset = 0;
                this.currentIndexSegment = (MemorySegment)BinaryInMemorySortBuffer.this.sortIndex.get(0);
            }

            @Override
            public BinaryRowData next(BinaryRowData target) {
                if (this.current < this.size) {
                    ++this.current;
                    if (this.currentOffset > BinaryInMemorySortBuffer.this.lastIndexEntryOffset) {
                        this.currentOffset = 0;
                        this.currentIndexSegment = (MemorySegment)BinaryInMemorySortBuffer.this.sortIndex.get(++this.currentSegment);
                    }
                    long pointer = this.currentIndexSegment.getLong(this.currentOffset);
                    this.currentOffset += BinaryInMemorySortBuffer.this.indexEntrySize;
                    try {
                        return BinaryInMemorySortBuffer.this.getRecordFromBuffer(target, pointer);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                return null;
            }

            @Override
            public BinaryRowData next() {
                throw new RuntimeException("Not support!");
            }
        };
    }
}

