/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.slots;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.util.Preconditions;

public class ResourceRequirement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ResourceProfile resourceProfile;
    private final int numberOfRequiredSlots;

    private ResourceRequirement(ResourceProfile resourceProfile, int numberOfRequiredSlots) {
        Preconditions.checkNotNull(resourceProfile);
        Preconditions.checkArgument(numberOfRequiredSlots > 0);
        this.resourceProfile = resourceProfile;
        this.numberOfRequiredSlots = numberOfRequiredSlots;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public int getNumberOfRequiredSlots() {
        return this.numberOfRequiredSlots;
    }

    public static ResourceRequirement create(ResourceProfile resourceProfile, int numberOfRequiredSlots) {
        return new ResourceRequirement(resourceProfile, numberOfRequiredSlots);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRequirement that = (ResourceRequirement)o;
        return this.numberOfRequiredSlots == that.numberOfRequiredSlots && Objects.equals(this.resourceProfile, that.resourceProfile);
    }

    public int hashCode() {
        return Objects.hash(this.resourceProfile, this.numberOfRequiredSlots);
    }

    public String toString() {
        return "ResourceRequirement{resourceProfile=" + this.resourceProfile + ", numberOfRequiredSlots=" + this.numberOfRequiredSlots + '}';
    }
}

