/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.util.metrics.CountingCollector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpDriver<T>
implements Driver<AbstractRichFunction, T> {
    private static final Logger LOG = LoggerFactory.getLogger(NoOpDriver.class);
    private TaskContext<AbstractRichFunction, T> taskContext;
    private volatile boolean running;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(TaskContext<AbstractRichFunction, T> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<AbstractRichFunction> getStubType() {
        return null;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 0;
    }

    @Override
    public void prepare() {
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("NoOpDriver object reuse: " + (this.objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
        }
    }

    @Override
    public void run() throws Exception {
        Counter numRecordsIn = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsInCounter();
        Counter numRecordsOut = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsOutCounter();
        MutableObjectIterator input = this.taskContext.getInput(0);
        CountingCollector output = new CountingCollector(this.taskContext.getOutputCollector(), numRecordsOut);
        if (this.objectReuseEnabled) {
            Object record = this.taskContext.getInputSerializer(0).getSerializer().createInstance();
            while (this.running && (record = input.next(record)) != null) {
                numRecordsIn.inc();
                output.collect(record);
            }
        } else {
            Object record;
            while (this.running && (record = input.next()) != null) {
                numRecordsIn.inc();
                output.collect(record);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

