/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Array;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializer;
import org.apache.flink.util.Preconditions;

@Public
public class ObjectArrayTypeInfo<T, C>
extends TypeInformation<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> arrayType;
    private final TypeInformation<C> componentInfo;

    private ObjectArrayTypeInfo(Class<T> arrayType, TypeInformation<C> componentInfo) {
        this.arrayType = Preconditions.checkNotNull(arrayType);
        this.componentInfo = Preconditions.checkNotNull(componentInfo);
    }

    @Override
    @PublicEvolving
    public boolean isBasicType() {
        return false;
    }

    @Override
    @PublicEvolving
    public boolean isTupleType() {
        return false;
    }

    @Override
    @PublicEvolving
    public int getArity() {
        return 1;
    }

    @Override
    @PublicEvolving
    public int getTotalFields() {
        return 1;
    }

    @Override
    @PublicEvolving
    public Class<T> getTypeClass() {
        return this.arrayType;
    }

    @PublicEvolving
    public TypeInformation<C> getComponentInfo() {
        return this.componentInfo;
    }

    @Override
    @PublicEvolving
    public boolean isKeyType() {
        return false;
    }

    @Override
    @PublicEvolving
    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        return new GenericArraySerializer<C>(this.componentInfo.getTypeClass(), this.componentInfo.createSerializer(executionConfig));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.componentInfo + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ObjectArrayTypeInfo) {
            ObjectArrayTypeInfo objectArrayTypeInfo = (ObjectArrayTypeInfo)obj;
            return objectArrayTypeInfo.canEqual(this) && this.arrayType == objectArrayTypeInfo.arrayType && this.componentInfo.equals(objectArrayTypeInfo.componentInfo);
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof ObjectArrayTypeInfo;
    }

    @Override
    public int hashCode() {
        return 31 * this.arrayType.hashCode() + this.componentInfo.hashCode();
    }

    @PublicEvolving
    public static <T, C> ObjectArrayTypeInfo<T, C> getInfoFor(Class<T> arrayClass, TypeInformation<C> componentInfo) {
        Preconditions.checkNotNull(arrayClass);
        Preconditions.checkNotNull(componentInfo);
        Preconditions.checkArgument(arrayClass.isArray(), "Class " + arrayClass + " must be an array.");
        return new ObjectArrayTypeInfo<T, C>(arrayClass, componentInfo);
    }

    @PublicEvolving
    public static <T, C> ObjectArrayTypeInfo<T, C> getInfoFor(TypeInformation<C> componentInfo) {
        Preconditions.checkNotNull(componentInfo);
        return new ObjectArrayTypeInfo(Array.newInstance(componentInfo.getTypeClass(), 0).getClass(), componentInfo);
    }
}

