/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.TableType;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Table;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionalValidationListener
extends MetaStorePreEventListener {
    public static final Logger LOG = LoggerFactory.getLogger(TransactionalValidationListener.class);
    public static final String DEFAULT_TRANSACTIONAL_PROPERTY = "default";
    public static final String LEGACY_TRANSACTIONAL_PROPERTY = "legacy";

    TransactionalValidationListener(Configuration conf) {
        super(conf);
    }

    @Override
    public void onEvent(PreEventContext context) throws MetaException, NoSuchObjectException, InvalidOperationException {
        switch (context.getEventType()) {
            case CREATE_TABLE: {
                this.handle((PreCreateTableEvent)context);
                break;
            }
            case ALTER_TABLE: {
                this.handle((PreAlterTableEvent)context);
                break;
            }
        }
    }

    private void handle(PreAlterTableEvent context) throws MetaException {
        this.handleAlterTableTransactionalProp(context);
    }

    private void handle(PreCreateTableEvent context) throws MetaException {
        this.handleCreateTableTransactionalProp(context);
    }

    private void handleAlterTableTransactionalProp(PreAlterTableEvent context) throws MetaException {
        Table newTable = context.getNewTable();
        Map<String, String> parameters = newTable.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        HashSet<String> keys = new HashSet<String>(parameters.keySet());
        String transactionalValue = null;
        boolean transactionalValuePresent = false;
        boolean isTransactionalPropertiesPresent = false;
        String transactionalPropertiesValue = null;
        boolean hasValidTransactionalValue = false;
        for (String key : keys) {
            if ("transactional".equalsIgnoreCase(key)) {
                transactionalValuePresent = true;
                transactionalValue = parameters.get(key);
                parameters.remove(key);
            }
            if (!"transactional_properties".equalsIgnoreCase(key)) continue;
            isTransactionalPropertiesPresent = true;
            transactionalPropertiesValue = parameters.get(key);
        }
        if (transactionalValuePresent) {
            parameters.put("transactional", transactionalValue);
        }
        if ("true".equalsIgnoreCase(transactionalValue)) {
            if (!this.conformToAcid(newTable)) {
                throw new MetaException("The table must be bucketed and stored using an ACID compliant format (such as ORC)");
            }
            if (newTable.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
                throw new MetaException(newTable.getDbName() + "." + newTable.getTableName() + " cannot be declared transactional because it's an external table");
            }
            hasValidTransactionalValue = true;
        }
        Table oldTable = context.getOldTable();
        String oldTransactionalValue = null;
        String oldTransactionalPropertiesValue = null;
        for (String key : oldTable.getParameters().keySet()) {
            if ("transactional".equalsIgnoreCase(key)) {
                oldTransactionalValue = oldTable.getParameters().get(key);
            }
            if (!"transactional_properties".equalsIgnoreCase(key)) continue;
            oldTransactionalPropertiesValue = oldTable.getParameters().get(key);
        }
        if (oldTransactionalValue == null ? transactionalValue == null : oldTransactionalValue.equalsIgnoreCase(transactionalValue)) {
            hasValidTransactionalValue = true;
        }
        if (!hasValidTransactionalValue) {
            throw new MetaException("TBLPROPERTIES with 'transactional'='true' cannot be unset");
        }
        if (isTransactionalPropertiesPresent) {
            if (oldTransactionalValue == null) {
                this.initializeTransactionalProperties(newTable);
            } else if (oldTransactionalPropertiesValue == null || !oldTransactionalPropertiesValue.equalsIgnoreCase(transactionalPropertiesValue)) {
                throw new MetaException("TBLPROPERTIES with 'transactional_properties' cannot be altered after the table is created");
            }
        }
    }

    private void handleCreateTableTransactionalProp(PreCreateTableEvent context) throws MetaException {
        Table newTable = context.getTable();
        Map<String, String> parameters = newTable.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        String transactionalValue = null;
        boolean transactionalPropFound = false;
        HashSet<String> keys = new HashSet<String>(parameters.keySet());
        for (String key : keys) {
            if (!"transactional".equalsIgnoreCase(key)) continue;
            transactionalPropFound = true;
            transactionalValue = parameters.get(key);
            parameters.remove(key);
        }
        if (!transactionalPropFound) {
            return;
        }
        if ("false".equalsIgnoreCase(transactionalValue)) {
            LOG.info("'transactional'='false' is no longer a valid property and will be ignored");
            return;
        }
        if ("true".equalsIgnoreCase(transactionalValue)) {
            if (!this.conformToAcid(newTable)) {
                throw new MetaException("The table must be bucketed and stored using an ACID compliant format (such as ORC)");
            }
            if (newTable.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
                throw new MetaException(newTable.getDbName() + "." + newTable.getTableName() + " cannot be declared transactional because it's an external table");
            }
            parameters.put("transactional", Boolean.TRUE.toString());
            this.initializeTransactionalProperties(newTable);
            return;
        }
        throw new MetaException("'transactional' property of TBLPROPERTIES may only have value 'true'");
    }

    private boolean conformToAcid(Table table) throws MetaException {
        StorageDescriptor sd = table.getSd();
        if (sd.getBucketColsSize() < 1) {
            return false;
        }
        try {
            Class<?> inputFormatClass = Class.forName(sd.getInputFormat());
            Class<?> outputFormatClass = Class.forName(sd.getOutputFormat());
            if (inputFormatClass == null || outputFormatClass == null || !Class.forName("org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.io.AcidInputFormat").isAssignableFrom(inputFormatClass) || !Class.forName("org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.io.AcidOutputFormat").isAssignableFrom(outputFormatClass)) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            throw new MetaException("Invalid input/output format for table");
        }
        return true;
    }

    private void initializeTransactionalProperties(Table table) throws MetaException {
        String tableTransactionalProperties = null;
        Map<String, String> parameters = table.getParameters();
        if (parameters != null) {
            Set<String> keys = parameters.keySet();
            for (String key : keys) {
                if (!"transactional_properties".equalsIgnoreCase(key)) continue;
                tableTransactionalProperties = parameters.get(key).toLowerCase();
                parameters.remove(key);
                String validationError = this.validateTransactionalProperties(tableTransactionalProperties);
                if (validationError == null) break;
                throw new MetaException("Invalid transactional properties specified for the table with the error " + validationError);
            }
        }
        if (tableTransactionalProperties != null) {
            parameters.put("transactional_properties", tableTransactionalProperties);
        }
    }

    private String validateTransactionalProperties(String transactionalProperties) {
        boolean isValid = false;
        switch (transactionalProperties) {
            case "default": 
            case "legacy": {
                isValid = true;
                break;
            }
            default: {
                isValid = false;
            }
        }
        if (!isValid) {
            return "unknown value " + transactionalProperties + " for transactional_properties";
        }
        return null;
    }
}

