/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore;

import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.DeadlineException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deadline {
    private static final Logger LOG = LoggerFactory.getLogger((String)Deadline.class.getName());
    private long timeoutNanos;
    private long startTime = Long.MIN_VALUE;
    private String method;
    private static final ThreadLocal<Deadline> DEADLINE_THREAD_LOCAL = new ThreadLocal<Deadline>(){

        @Override
        protected Deadline initialValue() {
            return null;
        }
    };
    private static final long NO_DEADLINE = Long.MIN_VALUE;

    private Deadline(long timeoutMs) {
        this.timeoutNanos = timeoutMs * 1000000L;
    }

    private static void setCurrentDeadline(Deadline deadline) {
        DEADLINE_THREAD_LOCAL.set(deadline);
    }

    static Deadline getCurrentDeadline() {
        return DEADLINE_THREAD_LOCAL.get();
    }

    private static void removeCurrentDeadline() {
        DEADLINE_THREAD_LOCAL.remove();
    }

    public static void registerIfNot(long timeout) {
        if (Deadline.getCurrentDeadline() == null) {
            Deadline.setCurrentDeadline(new Deadline(timeout));
        }
    }

    public static void resetTimeout(long timeoutMs) throws MetaException {
        if (timeoutMs <= 0L) {
            throw Deadline.newMetaException(new DeadlineException("The reset timeout value should be larger than 0: " + timeoutMs));
        }
        Deadline deadline = Deadline.getCurrentDeadline();
        if (deadline == null) {
            throw Deadline.newMetaException(new DeadlineException("The threadlocal Deadline is null, please register it firstly."));
        }
        deadline.timeoutNanos = timeoutMs * 1000000L;
    }

    public static boolean startTimer(String method) throws MetaException {
        Deadline deadline = Deadline.getCurrentDeadline();
        if (deadline == null) {
            throw Deadline.newMetaException(new DeadlineException("The threadlocal Deadline is null, please register it firstly."));
        }
        if (deadline.startTime != Long.MIN_VALUE) {
            return false;
        }
        deadline.method = method;
        do {
            deadline.startTime = System.nanoTime();
        } while (deadline.startTime == Long.MIN_VALUE);
        return true;
    }

    public static void stopTimer() throws MetaException {
        Deadline deadline = Deadline.getCurrentDeadline();
        if (deadline == null) {
            throw Deadline.newMetaException(new DeadlineException("The threadlocal Deadline is null, please register it firstly."));
        }
        deadline.startTime = Long.MIN_VALUE;
        deadline.method = null;
    }

    public static void clear() {
        Deadline.removeCurrentDeadline();
    }

    public static void checkTimeout() throws MetaException {
        Deadline deadline = Deadline.getCurrentDeadline();
        if (deadline == null) {
            throw Deadline.newMetaException(new DeadlineException("The threadlocal Deadline is null, please register it first."));
        }
        deadline.check();
    }

    private void check() throws MetaException {
        try {
            if (this.startTime == Long.MIN_VALUE) {
                throw new DeadlineException("Should execute startTimer() method before checkTimeout. Error happens in method: " + this.method);
            }
            long elapsedTime = System.nanoTime() - this.startTime;
            if (elapsedTime > this.timeoutNanos) {
                throw new DeadlineException("Timeout when executing method: " + this.method + "; " + elapsedTime / 1000000L + "ms exceeds " + this.timeoutNanos / 1000000L + "ms");
            }
        }
        catch (DeadlineException e) {
            throw Deadline.newMetaException(e);
        }
    }

    private static MetaException newMetaException(DeadlineException e) {
        MetaException metaException = new MetaException(e.getMessage());
        metaException.initCause(e);
        return metaException;
    }
}

