/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.avro;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.AvroBuilder;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.AvroBulkWriter;

public class AvroWriterFactory<T>
implements BulkWriter.Factory<T> {
    private static final long serialVersionUID = 1L;
    private final AvroBuilder<T> avroBuilder;

    public AvroWriterFactory(AvroBuilder<T> avroBuilder) {
        this.avroBuilder = avroBuilder;
    }

    public BulkWriter<T> create(FSDataOutputStream out) throws IOException {
        return new AvroBulkWriter<T>(this.avroBuilder.createWriter(new CloseShieldOutputStream((OutputStream)out)));
    }

    private static class CloseShieldOutputStream
    extends OutputStream {
        private final OutputStream out;

        public CloseShieldOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.out.write(buffer);
        }

        @Override
        public void write(byte[] buffer, int off, int len) throws IOException {
            this.out.write(buffer, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

