/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.util;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.util.InstantiationUtil;

public class ParamUtils {
    public static void initializeMapWithDefaultValues(Map<Param<?>, Object> paramMap, WithParams<?> instance) {
        List<Param<?>> defaultParams = ParamUtils.getPublicFinalParamFields(instance);
        for (Param<?> param : defaultParams) {
            if (paramMap.containsKey(param)) continue;
            paramMap.put(param, param.defaultValue);
        }
    }

    public static List<Param<?>> getPublicFinalParamFields(Object object) {
        return ParamUtils.getPublicFinalParamFields(object, object.getClass());
    }

    private static List<Param<?>> getPublicFinalParamFields(Object object, Class<?> clazz) {
        ArrayList result = new ArrayList();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (!Param.class.isAssignableFrom(field.getType()) || !Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            try {
                result.add((Param)field.get(object));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to extract param from field " + field.getName(), e);
            }
        }
        if (clazz.getSuperclass() != null) {
            result.addAll(ParamUtils.getPublicFinalParamFields(object, clazz.getSuperclass()));
        }
        for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
            result.addAll(ParamUtils.getPublicFinalParamFields(object, annotatedElement));
        }
        return result;
    }

    public static <T> void setParam(WithParams<?> instance, Param<T> param, Object value) {
        instance.set(param, value);
    }

    public static void updateExistingParams(WithParams<?> instance, Map<Param<?>, Object> paramOverrides) {
        Set<Param<?>> existingParams = instance.getParamMap().keySet();
        for (Map.Entry<Param<?>, Object> entry : paramOverrides.entrySet()) {
            if (!existingParams.contains(entry.getKey())) continue;
            ParamUtils.setParam(instance, entry.getKey(), entry.getValue());
        }
    }

    public static <T extends WithParams<T>> T instantiateWithParams(Map<String, ?> jsonMap) throws ClassNotFoundException, IOException {
        String className = (String)jsonMap.get("className");
        Class<?> clazz = Class.forName(className);
        WithParams instance = (WithParams)InstantiationUtil.instantiate(clazz);
        HashMap nameToParam = new HashMap();
        for (Param<?> param : ParamUtils.getPublicFinalParamFields(instance)) {
            nameToParam.put(param.name, param);
        }
        if (jsonMap.containsKey("paramMap")) {
            Map paramMap = (Map)jsonMap.get("paramMap");
            for (Map.Entry entry : paramMap.entrySet()) {
                Param param = (Param)nameToParam.get(entry.getKey());
                ParamUtils.setParam(instance, param, param.jsonDecode(entry.getValue()));
            }
        }
        return (T)instance;
    }
}

