/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.param;

import java.util.List;
import java.util.Map;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidator;
import org.apache.flink.ml.param.ParamValidators;

public class VectorParam
extends Param<Vector> {
    public VectorParam(String name, String description, Vector defaultValue, ParamValidator<Vector> validator) {
        super(name, Vector.class, description, defaultValue, validator);
    }

    public VectorParam(String name, String description, Vector defaultValue) {
        this(name, description, defaultValue, ParamValidators.alwaysTrue());
    }

    @Override
    public Vector jsonDecode(Object object) {
        Map vecValues = (Map)object;
        if (vecValues.size() == 1) {
            List list = (List)vecValues.get("values");
            double[] values = new double[list.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (Double)list.get(i);
            }
            return new DenseVector(values);
        }
        if (vecValues.size() == 3) {
            List valuesList = (List)vecValues.get("values");
            List indicesList = (List)vecValues.get("indices");
            int n = (Integer)vecValues.get("n");
            double[] values = new double[valuesList.size()];
            int[] indices = new int[indicesList.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (Double)valuesList.get(i);
                indices[i] = (Integer)indicesList.get(i);
            }
            return new SparseVector(n, indices, values);
        }
        throw new UnsupportedOperationException("Vector parameter is invalid.");
    }
}

