/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg.typeinfo;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.ml.linalg.SparseVector;

public final class SparseVectorSerializer
extends TypeSerializerSingleton<SparseVector> {
    private static final long serialVersionUID = 1L;
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final SparseVectorSerializer INSTANCE = new SparseVectorSerializer();

    public boolean isImmutableType() {
        return false;
    }

    public SparseVector createInstance() {
        return new SparseVector(0, EMPTY_INT_ARRAY, EMPTY_DOUBLE_ARRAY);
    }

    public SparseVector copy(SparseVector from) {
        return new SparseVector(from.n, Arrays.copyOf(from.indices, from.indices.length), Arrays.copyOf(from.values, from.values.length));
    }

    public SparseVector copy(SparseVector from, SparseVector reuse) {
        if (from.values.length == reuse.values.length && from.n == reuse.n) {
            System.arraycopy(from.values, 0, reuse.values, 0, from.values.length);
            System.arraycopy(from.indices, 0, reuse.indices, 0, from.indices.length);
            return reuse;
        }
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(SparseVector vector, DataOutputView target) throws IOException {
        if (vector == null) {
            throw new IllegalArgumentException("The vector must not be null.");
        }
        target.writeInt(vector.n);
        int len = vector.values.length;
        target.writeInt(len);
        for (int i = 0; i < len; ++i) {
            target.writeInt(vector.indices[i]);
            target.writeDouble(vector.values[i]);
        }
    }

    private void readSparseVectorArrays(int[] indices, double[] values, DataInputView source, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            indices[i] = source.readInt();
            values[i] = source.readDouble();
        }
    }

    public SparseVector deserialize(DataInputView source) throws IOException {
        int n = source.readInt();
        int len = source.readInt();
        int[] indices = new int[len];
        double[] values = new double[len];
        this.readSparseVectorArrays(indices, values, source, len);
        return new SparseVector(n, indices, values);
    }

    public SparseVector deserialize(SparseVector reuse, DataInputView source) throws IOException {
        int n = source.readInt();
        int len = source.readInt();
        if (reuse.n == n && reuse.values.length == len) {
            this.readSparseVectorArrays(reuse.indices, reuse.values, source, len);
            return reuse;
        }
        int[] indices = new int[len];
        double[] values = new double[len];
        this.readSparseVectorArrays(indices, values, source, len);
        return new SparseVector(n, indices, values);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int n = source.readInt();
        int len = source.readInt();
        target.writeInt(n);
        target.writeInt(len);
        target.write(source, len * 12);
    }

    public TypeSerializerSnapshot<SparseVector> snapshotConfiguration() {
        return new SparseVectorSerializerSnapshot();
    }

    public static final class SparseVectorSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<SparseVector> {
        public SparseVectorSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

