/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg;

import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.SparseVectorTypeInfoFactory;
import org.apache.flink.util.Preconditions;

@TypeInfo(value=SparseVectorTypeInfoFactory.class)
@PublicEvolving
public class SparseVector
implements Vector {
    public final int n;
    public int[] indices;
    public double[] values;

    public SparseVector(int n, int[] indices, double[] values) {
        this.n = n;
        this.indices = indices;
        this.values = values;
        if (!this.isIndicesSorted()) {
            this.sortIndices();
        }
        this.validateSortedData();
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public double get(int i) {
        int pos = Arrays.binarySearch(this.indices, i);
        if (pos >= 0) {
            return this.values[pos];
        }
        return 0.0;
    }

    @Override
    public void set(int i, double value) {
        int pos = Arrays.binarySearch(this.indices, i);
        if (pos >= 0) {
            this.values[pos] = value;
        } else if (value != 0.0) {
            Preconditions.checkArgument((i < this.n ? 1 : 0) != 0, (Object)("Index out of bounds: " + i));
            int[] indices = new int[this.indices.length + 1];
            double[] values = new double[this.indices.length + 1];
            System.arraycopy(this.indices, 0, indices, 0, -pos - 1);
            System.arraycopy(this.values, 0, values, 0, -pos - 1);
            indices[-pos - 1] = i;
            values[-pos - 1] = value;
            System.arraycopy(this.indices, -pos - 1, indices, -pos, this.indices.length + pos + 1);
            System.arraycopy(this.values, -pos - 1, values, -pos, this.indices.length + pos + 1);
            this.indices = indices;
            this.values = values;
        }
    }

    @Override
    public double[] toArray() {
        double[] result = new double[this.n];
        for (int i = 0; i < this.indices.length; ++i) {
            result[this.indices[i]] = this.values[i];
        }
        return result;
    }

    @Override
    public DenseVector toDense() {
        return new DenseVector(this.toArray());
    }

    @Override
    public SparseVector toSparse() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparseVector that = (SparseVector)o;
        return this.n == that.n && Arrays.equals(this.indices, that.indices) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        int result = Objects.hash(this.n);
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    private void validateSortedData() {
        Preconditions.checkArgument((this.indices.length == this.values.length ? 1 : 0) != 0, (Object)"Indices size and values size should be the same.");
        if (this.indices.length > 0) {
            Preconditions.checkArgument((this.indices[0] >= 0 && this.indices[this.indices.length - 1] < this.n ? 1 : 0) != 0, (Object)"Index out of bound.");
        }
        for (int i = 1; i < this.indices.length; ++i) {
            Preconditions.checkArgument((this.indices[i] > this.indices[i - 1] ? 1 : 0) != 0, (Object)"Indices duplicated.");
        }
    }

    private boolean isIndicesSorted() {
        for (int i = 1; i < this.indices.length; ++i) {
            if (this.indices[i] >= this.indices[i - 1]) continue;
            return false;
        }
        return true;
    }

    private void sortIndices() {
        SparseVector.sortImpl(this.indices, this.values, 0, this.indices.length - 1);
    }

    private static void sortImpl(int[] indices, double[] values, int low, int high) {
        int pivotPos = (low + high) / 2;
        int pivot = indices[pivotPos];
        SparseVector.swapIndexAndValue(indices, values, pivotPos, high);
        int pos = low - 1;
        for (int i = low; i <= high; ++i) {
            if (indices[i] > pivot) continue;
            SparseVector.swapIndexAndValue(indices, values, ++pos, i);
        }
        if (high > pos + 1) {
            SparseVector.sortImpl(indices, values, pos + 1, high);
        }
        if (pos - 1 > low) {
            SparseVector.sortImpl(indices, values, low, pos - 1);
        }
    }

    private static void swapIndexAndValue(int[] indices, double[] values, int index1, int index2) {
        int tempIndex = indices[index1];
        indices[index1] = indices[index2];
        indices[index2] = tempIndex;
        double tempValue = values[index1];
        values[index1] = values[index2];
        values[index2] = tempValue;
    }

    public String toString() {
        String sbr = "(" + this.n + ", " + Arrays.toString(this.indices) + ", " + Arrays.toString(this.values) + ")";
        return sbr;
    }

    @Override
    public SparseVector clone() {
        return new SparseVector(this.n, (int[])this.indices.clone(), (double[])this.values.clone());
    }
}

