/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.vectorassembler;

import org.apache.flink.ml.common.param.HasHandleInvalid;
import org.apache.flink.ml.common.param.HasInputCols;
import org.apache.flink.ml.common.param.HasOutputCol;
import org.apache.flink.ml.param.IntArrayParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidator;

public interface VectorAssemblerParams<T>
extends HasInputCols<T>,
HasOutputCol<T>,
HasHandleInvalid<T> {
    public static final Param<Integer[]> INPUT_SIZES = new IntArrayParam("inputSizes", "Sizes of the input elements to be assembled.", null, VectorAssemblerParams.sizesValidator());

    default public Integer[] getInputSizes() {
        return this.get(INPUT_SIZES);
    }

    default public T setInputSizes(Integer ... value) {
        return this.set(INPUT_SIZES, value);
    }

    public static ParamValidator<Integer[]> sizesValidator() {
        return inputSizes -> {
            if (inputSizes == null) {
                return false;
            }
            for (Integer size : inputSizes) {
                if (size > 0) continue;
                return false;
            }
            return ((Integer[])inputSizes).length != 0;
        };
    }
}

