/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.distance;

import java.io.Serializable;
import org.apache.flink.ml.common.distance.CosineDistanceMeasure;
import org.apache.flink.ml.common.distance.EuclideanDistanceMeasure;
import org.apache.flink.ml.common.distance.ManhattanDistanceMeasure;
import org.apache.flink.ml.linalg.VectorWithNorm;

public interface DistanceMeasure
extends Serializable {
    public static DistanceMeasure getInstance(String distanceMeasure) {
        switch (distanceMeasure) {
            case "euclidean": {
                return EuclideanDistanceMeasure.getInstance();
            }
            case "manhattan": {
                return ManhattanDistanceMeasure.getInstance();
            }
            case "cosine": {
                return CosineDistanceMeasure.getInstance();
            }
        }
        throw new IllegalArgumentException("distanceMeasure " + distanceMeasure + " is not recognized. Supported options: 'euclidean, manhattan, cosine'.");
    }

    public double distance(VectorWithNorm var1, VectorWithNorm var2);

    default public int findClosest(VectorWithNorm[] centroids, VectorWithNorm point) {
        int targetCentroidId = -1;
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < centroids.length; ++i) {
            double distance = this.distance(centroids[i], point);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            targetCentroidId = i;
        }
        return targetCentroidId;
    }
}

