/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.broadcast;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.java.tuple.Tuple2;

public class BroadcastContext {
    private static final ConcurrentHashMap<String, BroadcastItem> BROADCAST_VARIABLES = new ConcurrentHashMap();

    @VisibleForTesting
    public static void putBroadcastVariable(String key, Tuple2<Boolean, List<?>> variable) {
        BROADCAST_VARIABLES.compute(key, (k, v) -> null == v ? new BroadcastItem((Boolean)variable.f0, (List)variable.f1, null) : new BroadcastItem((Boolean)variable.f0, (List)variable.f1, ((BroadcastItem)v).mailboxExecutor));
    }

    @VisibleForTesting
    public static void putMailBoxExecutor(String key, MailboxExecutor mailboxExecutor) {
        BROADCAST_VARIABLES.compute(key, (k, v) -> null == v ? new BroadcastItem(false, null, mailboxExecutor) : new BroadcastItem(((BroadcastItem)v).cacheReady, ((BroadcastItem)v).cacheList, mailboxExecutor));
    }

    @VisibleForTesting
    public static <T> List<T> getBroadcastVariable(String key) {
        return BROADCAST_VARIABLES.get(key).cacheList;
    }

    @VisibleForTesting
    public static void remove(String key) {
        BROADCAST_VARIABLES.remove(key);
    }

    @VisibleForTesting
    public static void notifyCacheFinished(String key) {
        BROADCAST_VARIABLES.computeIfPresent(key, (k, v) -> {
            if (null != ((BroadcastItem)v).mailboxExecutor) {
                ((BroadcastItem)v).mailboxExecutor.execute(() -> {}, "empty mail");
            }
            return new BroadcastItem(true, ((BroadcastItem)v).cacheList, ((BroadcastItem)v).mailboxExecutor);
        });
    }

    @VisibleForTesting
    public static boolean isCacheFinished(String key) {
        return BROADCAST_VARIABLES.get(key).cacheReady;
    }

    private static class BroadcastItem {
        private boolean cacheReady;
        private List<?> cacheList;
        private MailboxExecutor mailboxExecutor;

        BroadcastItem(boolean cacheReady, @Nullable List<?> cacheList, @Nullable MailboxExecutor mailboxExecutor) {
            this.cacheReady = cacheReady;
            this.cacheList = cacheList;
            this.mailboxExecutor = mailboxExecutor;
        }
    }
}

