/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.clustering.kmeans;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.clustering.kmeans.KMeansModelData;
import org.apache.flink.ml.clustering.kmeans.KMeansModelParams;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.common.distance.DistanceMeasure;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.VectorWithNorm;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class KMeansModel
implements Model<KMeansModel>,
KMeansModelParams<KMeansModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public KMeansModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public KMeansModel setModelData(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        this.modelDataTable = inputs[0];
        return this;
    }

    @Override
    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream<KMeansModelData> modelDataStream = KMeansModelData.getModelDataStream(this.modelDataTable);
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{Types.INT}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getPredictionCol()}));
        String broadcastModelKey = "broadcastModelKey";
        DataStream predictionResult = BroadcastUtils.withBroadcastStream(Collections.singletonList(tEnv.toDataStream(inputs[0])), Collections.singletonMap("broadcastModelKey", modelDataStream), inputList -> {
            DataStream inputData = (DataStream)inputList.get(0);
            return inputData.map((MapFunction)new PredictLabelFunction("broadcastModelKey", this.getFeaturesCol(), DistanceMeasure.getInstance(this.getDistanceMeasure()), this.getK()), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(predictionResult)};
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveModelData(KMeansModelData.getModelDataStream(this.modelDataTable), path, new KMeansModelData.ModelDataEncoder());
        ReadWriteUtils.saveMetadata(this, path);
    }

    public static KMeansModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        Table modelDataTable = ReadWriteUtils.loadModelData(tEnv, path, new KMeansModelData.ModelDataDecoder());
        KMeansModel model = (KMeansModel)ReadWriteUtils.loadStageParam(path);
        return model.setModelData(modelDataTable);
    }

    private static class PredictLabelFunction
    extends RichMapFunction<Row, Row> {
        private final String broadcastModelKey;
        private final String featuresCol;
        private final DistanceMeasure distanceMeasure;
        private final int k;
        private VectorWithNorm[] centroids;

        public PredictLabelFunction(String broadcastModelKey, String featuresCol, DistanceMeasure distanceMeasure, int k) {
            this.broadcastModelKey = broadcastModelKey;
            this.featuresCol = featuresCol;
            this.distanceMeasure = distanceMeasure;
            this.k = k;
        }

        public Row map(Row dataPoint) {
            if (this.centroids == null) {
                KMeansModelData modelData = (KMeansModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastModelKey).get(0);
                Preconditions.checkArgument((modelData.centroids.length <= this.k ? 1 : 0) != 0);
                this.centroids = new VectorWithNorm[modelData.centroids.length];
                for (int i = 0; i < modelData.centroids.length; ++i) {
                    this.centroids[i] = new VectorWithNorm(modelData.centroids[i]);
                }
            }
            DenseVector point = ((Vector)dataPoint.getField(this.featuresCol)).toDense();
            int closestCentroidId = this.distanceMeasure.findClosest(this.centroids, new VectorWithNorm(point));
            return Row.join((Row)dataPoint, (Row[])new Row[]{Row.of((Object[])new Object[]{closestCentroidId})});
        }
    }
}

