/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.classification.linearsvc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class LinearSVCModelData {
    public DenseVector coefficient;

    public LinearSVCModelData(DenseVector coefficient) {
        this.coefficient = coefficient;
    }

    public LinearSVCModelData() {
    }

    public static DataStream<LinearSVCModelData> getModelDataStream(Table modelData) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelData).getTableEnvironment();
        return tEnv.toDataStream(modelData).map((MapFunction & Serializable)x -> new LinearSVCModelData(((Vector)x.getField(0)).toDense()));
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<LinearSVCModelData> {
        public StreamFormat.Reader<LinearSVCModelData> createReader(Configuration configuration, final FSDataInputStream inputStream) {
            return new StreamFormat.Reader<LinearSVCModelData>(){
                private final DenseVectorSerializer serializer = new DenseVectorSerializer();

                public LinearSVCModelData read() throws IOException {
                    try {
                        DenseVector coefficient = this.serializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)inputStream));
                        return new LinearSVCModelData(coefficient);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    inputStream.close();
                }
            };
        }

        public TypeInformation<LinearSVCModelData> getProducedType() {
            return TypeInformation.of(LinearSVCModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<LinearSVCModelData> {
        private final DenseVectorSerializer serializer = new DenseVectorSerializer();

        public void encode(LinearSVCModelData modelData, OutputStream outputStream) throws IOException {
            this.serializer.serialize(modelData.coefficient, (DataOutputView)new DataOutputViewStreamWrapper(outputStream));
        }
    }
}

