/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.ml.api.AlgoOperator;
import org.apache.flink.ml.api.Estimator;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.builder.GraphData;
import org.apache.flink.ml.builder.GraphExecutionHelper;
import org.apache.flink.ml.builder.GraphNode;
import org.apache.flink.ml.builder.TableId;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class GraphModel
implements Model<GraphModel> {
    private static final long serialVersionUID = 6354856913812529398L;
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private final List<GraphNode> nodes;
    private final TableId[] inputIds;
    private final TableId[] outputIds;
    @Nullable
    private final TableId[] inputModelDataIds;
    @Nullable
    private final TableId[] outputModelDataIds;
    private final GraphExecutionHelper executionHelper;

    public GraphModel(List<GraphNode> nodes, TableId[] inputIds, TableId[] outputIds, TableId[] inputModelDataIds, TableId[] outputModelDataIds) {
        this.nodes = (List)Preconditions.checkNotNull(nodes);
        this.inputIds = (TableId[])Preconditions.checkNotNull((Object)inputIds);
        this.outputIds = (TableId[])Preconditions.checkNotNull((Object)outputIds);
        this.inputModelDataIds = inputModelDataIds;
        this.outputModelDataIds = outputModelDataIds;
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
        this.executionHelper = new GraphExecutionHelper(nodes);
    }

    @Override
    public Table[] transform(Table ... inputTables) {
        GraphNode node;
        Preconditions.checkArgument((this.inputIds.length == inputTables.length ? 1 : 0) != 0, (String)"number of provided tables %s does not match the expected number of tables %s", (Object[])new Object[]{inputTables.length, this.inputIds.length});
        this.executionHelper.setTables(this.inputIds, inputTables);
        while ((node = this.executionHelper.pollNextReadyNode()) != null) {
            Stage<Object> stage = node.stage;
            if (node.stageType == GraphNode.StageType.ESTIMATOR) {
                stage = ((Estimator)stage).fit(this.executionHelper.getTables(node.estimatorInputIds));
            }
            if (node.inputModelDataIds != null) {
                Table[] nodeInputModelData = this.executionHelper.getTables(node.inputModelDataIds);
                ((Model)stage).setModelData(nodeInputModelData);
            }
            Table[] nodeOutputs = ((AlgoOperator)stage).transform(this.executionHelper.getTables(node.algoOpInputIds));
            this.executionHelper.setTables(node.outputIds, nodeOutputs);
            if (node.outputModelDataIds == null) continue;
            Table[] nodeOutputModelData = ((Model)stage).getModelData();
            this.executionHelper.setTables(node.outputModelDataIds, nodeOutputModelData);
        }
        return this.executionHelper.getTables(this.outputIds);
    }

    @Override
    public GraphModel setModelData(Table ... inputTables) {
        Preconditions.checkArgument((this.inputModelDataIds != null ? 1 : 0) != 0, (Object)"setModelData() is not supported");
        Preconditions.checkArgument((this.inputModelDataIds.length == inputTables.length ? 1 : 0) != 0, (String)"number of provided tables %s does not match the expected number of tables %s", (Object[])new Object[]{inputTables.length, this.inputIds.length});
        this.executionHelper.setTables(this.inputModelDataIds, inputTables);
        return this;
    }

    @Override
    public Table[] getModelData() {
        Preconditions.checkArgument((this.outputModelDataIds != null ? 1 : 0) != 0);
        return this.executionHelper.getTables(this.outputModelDataIds);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    @Override
    public void save(String path) throws IOException {
        GraphData graphData = new GraphData(this.nodes, null, this.inputIds, this.outputIds, this.inputModelDataIds, this.outputModelDataIds);
        ReadWriteUtils.saveGraph(this, graphData, path);
    }

    public static GraphModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        return (GraphModel)ReadWriteUtils.loadGraph(tEnv, path, GraphModel.class.getName());
    }
}

