/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.benchmark.datagenerator.clustering;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.ml.benchmark.datagenerator.DataGenerator;
import org.apache.flink.ml.benchmark.datagenerator.common.DenseVectorArrayGenerator;
import org.apache.flink.ml.benchmark.datagenerator.param.HasArraySize;
import org.apache.flink.ml.benchmark.datagenerator.param.HasVectorDim;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.inference.TypeInference;

public class KMeansModelDataGenerator
implements DataGenerator<KMeansModelDataGenerator>,
HasVectorDim<KMeansModelDataGenerator>,
HasArraySize<KMeansModelDataGenerator> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public KMeansModelDataGenerator() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] getData(StreamTableEnvironment tEnv) {
        DenseVectorArrayGenerator vectorArrayGenerator = new DenseVectorArrayGenerator();
        ParamUtils.updateExistingParams(vectorArrayGenerator, this.paramMap);
        vectorArrayGenerator.setNumValues(1L);
        vectorArrayGenerator.setColNames(new String[][]{{"centroids"}});
        Table centroidsTable = vectorArrayGenerator.getData(tEnv)[0];
        Table modelDataTable = centroidsTable.select(new Expression[]{Expressions.$((String)"centroids"), (Expression)Expressions.call(GenerateWeightsFunction.class, (Object[])new Object[]{Expressions.$((String)"centroids")}).as("weights", new String[0])});
        return new Table[]{modelDataTable};
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    public static class GenerateWeightsFunction
    extends ScalarFunction {
        public DenseVector eval(DenseVector[] centroids) {
            return new DenseVector(centroids.length);
        }

        public TypeInference getTypeInference(DataTypeFactory typeFactory) {
            return TypeInference.newBuilder().outputTypeStrategy(callContext -> Optional.of(DataTypes.of((TypeInformation)DenseVectorTypeInfo.INSTANCE).toDataType(typeFactory))).build();
        }
    }
}

