/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.proxy.state;

import java.io.IOException;
import java.util.concurrent.RunnableFuture;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.iteration.proxy.state.StateNamePrefix;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointableKeyedStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupedInternalPriorityQueue;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.KeyedStateFunction;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.PriorityComparable;
import org.apache.flink.runtime.state.SavepointResources;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueElement;

public class ProxyKeyedStateBackend<K>
implements CheckpointableKeyedStateBackend<K> {
    private final CheckpointableKeyedStateBackend<K> wrappedBackend;
    private final StateNamePrefix stateNamePrefix;

    public ProxyKeyedStateBackend(CheckpointableKeyedStateBackend<K> wrappedBackend, StateNamePrefix stateNamePrefix) {
        this.wrappedBackend = wrappedBackend;
        this.stateNamePrefix = stateNamePrefix;
    }

    public void setCurrentKey(K newKey) {
        this.wrappedBackend.setCurrentKey(newKey);
    }

    public K getCurrentKey() {
        return (K)this.wrappedBackend.getCurrentKey();
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.wrappedBackend.getKeySerializer();
    }

    public <N, S extends State, T> void applyToAllKeys(N namespace, TypeSerializer<N> namespaceSerializer, StateDescriptor<S, T> stateDescriptor, KeyedStateFunction<K, S> function) throws Exception {
        StateDescriptor<S, T> newDescriptor = this.createNewDescriptor(stateDescriptor);
        this.wrappedBackend.applyToAllKeys(namespace, namespaceSerializer, newDescriptor, function);
    }

    public <N> Stream<K> getKeys(String state, N namespace) {
        return this.wrappedBackend.getKeys(this.stateNamePrefix.prefix(state), namespace);
    }

    public <N> Stream<Tuple2<K, N>> getKeysAndNamespaces(String state) {
        return this.wrappedBackend.getKeysAndNamespaces(this.stateNamePrefix.prefix(state));
    }

    public <N, S extends State, T> S getOrCreateKeyedState(TypeSerializer<N> namespaceSerializer, StateDescriptor<S, T> stateDescriptor) throws Exception {
        StateDescriptor<S, T> newDescriptor = this.createNewDescriptor(stateDescriptor);
        return (S)this.wrappedBackend.getOrCreateKeyedState(namespaceSerializer, newDescriptor);
    }

    public <N, S extends State> S getPartitionedState(N namespace, TypeSerializer<N> namespaceSerializer, StateDescriptor<S, ?> stateDescriptor) throws Exception {
        StateDescriptor<S, ?> newDescriptor = this.createNewDescriptor(stateDescriptor);
        return (S)this.wrappedBackend.getPartitionedState(namespace, namespaceSerializer, newDescriptor);
    }

    public void registerKeySelectionListener(KeyedStateBackend.KeySelectionListener<K> listener) {
        this.wrappedBackend.registerKeySelectionListener(listener);
    }

    public boolean deregisterKeySelectionListener(KeyedStateBackend.KeySelectionListener<K> listener) {
        return this.wrappedBackend.deregisterKeySelectionListener(listener);
    }

    @Nonnull
    public <N, SV, SEV, S extends State, IS extends S> IS createInternalState(@Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull StateDescriptor<S, SV> stateDesc, @Nonnull StateSnapshotTransformer.StateSnapshotTransformFactory<SEV> snapshotTransformFactory) throws Exception {
        StateDescriptor<S, SV> newDescriptor = this.createNewDescriptor(stateDesc);
        return (IS)this.wrappedBackend.createInternalState(namespaceSerializer, newDescriptor, snapshotTransformFactory);
    }

    protected <S extends State, T> StateDescriptor<S, T> createNewDescriptor(StateDescriptor<S, T> descriptor) {
        switch (descriptor.getType()) {
            case VALUE: {
                return new ValueStateDescriptor(this.stateNamePrefix.prefix(descriptor.getName()), descriptor.getSerializer());
            }
            case LIST: {
                ListStateDescriptor listStateDescriptor = (ListStateDescriptor)descriptor;
                return new ListStateDescriptor(this.stateNamePrefix.prefix(listStateDescriptor.getName()), listStateDescriptor.getElementSerializer());
            }
            case REDUCING: {
                ReducingStateDescriptor reducingStateDescriptor = (ReducingStateDescriptor)descriptor;
                return new ReducingStateDescriptor(this.stateNamePrefix.prefix(reducingStateDescriptor.getName()), reducingStateDescriptor.getReduceFunction(), reducingStateDescriptor.getSerializer());
            }
            case AGGREGATING: {
                AggregatingStateDescriptor aggregatingStateDescriptor = (AggregatingStateDescriptor)descriptor;
                return new AggregatingStateDescriptor(this.stateNamePrefix.prefix(aggregatingStateDescriptor.getName()), aggregatingStateDescriptor.getAggregateFunction(), aggregatingStateDescriptor.getSerializer());
            }
            case MAP: {
                MapStateDescriptor mapStateDescriptor = (MapStateDescriptor)descriptor;
                return new MapStateDescriptor(this.stateNamePrefix.prefix(mapStateDescriptor.getName()), mapStateDescriptor.getKeySerializer(), mapStateDescriptor.getValueSerializer());
            }
        }
        throw new UnsupportedOperationException("Unsupported state type");
    }

    public KeyGroupRange getKeyGroupRange() {
        return this.wrappedBackend.getKeyGroupRange();
    }

    @Nonnull
    public SavepointResources<K> savepoint() throws Exception {
        return this.wrappedBackend.savepoint();
    }

    public void dispose() {
    }

    public void close() throws IOException {
    }

    @Nonnull
    public <T extends HeapPriorityQueueElement & PriorityComparable<? super T>> KeyGroupedInternalPriorityQueue<T> create(@Nonnull String stateName, @Nonnull TypeSerializer<T> byteOrderedElementSerializer) {
        return this.wrappedBackend.create(this.stateNamePrefix.prefix(stateName), byteOrderedElementSerializer);
    }

    @Nonnull
    public RunnableFuture<SnapshotResult<KeyedStateHandle>> snapshot(long checkpointId, long timestamp, @Nonnull CheckpointStreamFactory streamFactory, @Nonnull CheckpointOptions checkpointOptions) throws Exception {
        return this.wrappedBackend.snapshot(checkpointId, timestamp, streamFactory, checkpointOptions);
    }
}

