/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator.perround;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.operator.OperatorUtils;
import org.apache.flink.iteration.operator.perround.AbstractPerRoundWrapperOperator;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.MultipleInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.FlinkRuntimeException;

public class MultipleInputPerRoundWrapperOperator<OUT>
extends AbstractPerRoundWrapperOperator<OUT, MultipleInputStreamOperator<OUT>>
implements MultipleInputStreamOperator<IterationRecord<OUT>> {
    private final int numberOfInputs;
    private final Map<Integer, List<Input>> operatorInputsByEpoch = new HashMap<Integer, List<Input>>();

    public MultipleInputPerRoundWrapperOperator(StreamOperatorParameters<IterationRecord<OUT>> parameters, StreamOperatorFactory<OUT> operatorFactory) {
        super(parameters, operatorFactory);
        List inEdges = this.streamConfig.getInPhysicalEdges(this.containingTask.getUserCodeClassLoader());
        this.numberOfInputs = inEdges.stream().map(StreamEdge::getTypeNumber).collect(Collectors.toSet()).size();
    }

    @Override
    protected MultipleInputStreamOperator<OUT> getWrappedOperator(int epoch) {
        MultipleInputStreamOperator operator = (MultipleInputStreamOperator)super.getWrappedOperator(epoch);
        this.operatorInputsByEpoch.put(epoch, operator.getInputs());
        return operator;
    }

    @Override
    protected void endInputAndEmitMaxWatermark(MultipleInputStreamOperator<OUT> operator, int epoch, int epochWatermark) throws Exception {
        OperatorUtils.processOperatorOrUdfIfSatisfy(operator, BoundedMultiInput.class, boundedMultiInput -> {
            for (int i = 0; i < this.numberOfInputs; ++i) {
                boundedMultiInput.endInput(i + 1);
            }
        });
        for (int i = 0; i < this.numberOfInputs; ++i) {
            this.operatorInputsByEpoch.get(epoch).get(i).processWatermark(new Watermark(Long.MAX_VALUE));
        }
    }

    @Override
    protected void closeStreamOperator(MultipleInputStreamOperator<OUT> operator, int epoch, int epochWatermark) throws Exception {
        super.closeStreamOperator(operator, epoch, epochWatermark);
        this.operatorInputsByEpoch.remove(epoch);
    }

    public List<Input> getInputs() {
        ArrayList<Input> proxyInputs = new ArrayList<Input>();
        for (int i = 0; i < this.numberOfInputs; ++i) {
            proxyInputs.add(new ProxyInput(i));
        }
        return proxyInputs;
    }

    private class ProxyInput<IN>
    implements Input<IterationRecord<IN>> {
        private final int inputIndex;
        private final StreamRecord<IN> reusedInput;

        public ProxyInput(int inputIndex) {
            this.inputIndex = inputIndex;
            this.reusedInput = new StreamRecord(null, 0L);
        }

        public void processElement(StreamRecord<IterationRecord<IN>> element) throws Exception {
            switch (((IterationRecord)element.getValue()).getType()) {
                case RECORD: {
                    MultipleInputPerRoundWrapperOperator.this.getWrappedOperator(((IterationRecord)element.getValue()).getEpoch());
                    this.reusedInput.replace(((IterationRecord)element.getValue()).getValue(), element.getTimestamp());
                    MultipleInputPerRoundWrapperOperator.this.setIterationContextRound(((IterationRecord)element.getValue()).getEpoch());
                    ((Input)((List)MultipleInputPerRoundWrapperOperator.this.operatorInputsByEpoch.get(((IterationRecord)element.getValue()).getEpoch())).get(this.inputIndex)).processElement(this.reusedInput);
                    MultipleInputPerRoundWrapperOperator.this.clearIterationContextRound();
                    break;
                }
                case EPOCH_WATERMARK: {
                    MultipleInputPerRoundWrapperOperator.this.onEpochWatermarkEvent(this.inputIndex, (IterationRecord)element.getValue());
                    break;
                }
                default: {
                    throw new FlinkRuntimeException("Not supported iteration record type: " + element);
                }
            }
        }

        public void processWatermark(Watermark mark) throws Exception {
            MultipleInputPerRoundWrapperOperator.this.processForEachWrappedOperator((round, wrappedOperator) -> ((Input)((List)MultipleInputPerRoundWrapperOperator.this.operatorInputsByEpoch.get(round)).get(this.inputIndex)).processWatermark(mark));
        }

        public void processWatermarkStatus(WatermarkStatus watermarkStatus) throws Exception {
            MultipleInputPerRoundWrapperOperator.this.processForEachWrappedOperator((round, wrappedOperator) -> ((Input)((List)MultipleInputPerRoundWrapperOperator.this.operatorInputsByEpoch.get(round)).get(this.inputIndex)).processWatermarkStatus(watermarkStatus));
        }

        public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
            MultipleInputPerRoundWrapperOperator.this.reportOrForwardLatencyMarker(latencyMarker);
        }

        public void setKeyContextElement(StreamRecord<IterationRecord<IN>> element) throws Exception {
            if (((IterationRecord)element.getValue()).getType() == IterationRecord.Type.RECORD) {
                MultipleInputPerRoundWrapperOperator.this.getWrappedOperator(((IterationRecord)element.getValue()).getEpoch());
                this.reusedInput.replace((Object)((IterationRecord)element.getValue()), element.getTimestamp());
                ((Input)((List)MultipleInputPerRoundWrapperOperator.this.operatorInputsByEpoch.get(((IterationRecord)element.getValue()).getEpoch())).get(this.inputIndex)).setKeyContextElement(this.reusedInput);
            }
        }
    }
}

