/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.collections.IteratorUtils;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheReader;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheSnapshot;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheWriter;
import org.apache.flink.iteration.operator.OperatorStateUtils;
import org.apache.flink.iteration.operator.OperatorUtils;
import org.apache.flink.iteration.progresstrack.OperatorEpochWatermarkTracker;
import org.apache.flink.iteration.progresstrack.OperatorEpochWatermarkTrackerFactory;
import org.apache.flink.iteration.progresstrack.OperatorEpochWatermarkTrackerListener;
import org.apache.flink.iteration.typeinfo.IterationRecordSerializer;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StatePartitionStreamProvider;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

public class ReplayOperator<T>
extends AbstractStreamOperator<IterationRecord<T>>
implements TwoInputStreamOperator<IterationRecord<T>, IterationRecord<Void>, IterationRecord<T>>,
OperatorEpochWatermarkTrackerListener,
BoundedMultiInput {
    private OperatorEpochWatermarkTracker progressTracker;
    private Path basePath;
    private FileSystem fileSystem;
    private TypeSerializer<T> typeSerializer;
    private MailboxExecutor mailboxExecutor;
    private DataCacheWriter<T> dataCacheWriter;
    @Nullable
    private DataCacheReader<T> currentDataCacheReader;
    private int currentEpoch;
    private ListState<Integer> parallelismState;
    private ListState<Integer> currentEpochState;

    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<IterationRecord<T>>> output) {
        super.setup(containingTask, config, output);
        this.progressTracker = OperatorEpochWatermarkTrackerFactory.create(config, containingTask, this);
        try {
            this.basePath = OperatorUtils.getDataCachePath(containingTask.getEnvironment().getTaskManagerInfo().getConfiguration(), containingTask.getEnvironment().getIOManager().getSpillingDirectoriesPaths());
            this.fileSystem = this.basePath.getFileSystem();
            IterationRecordSerializer iterationRecordSerializer = (IterationRecordSerializer)config.getTypeSerializerOut(this.getClass().getClassLoader());
            this.typeSerializer = iterationRecordSerializer.getInnerSerializer();
            this.mailboxExecutor = containingTask.getMailboxExecutorFactory().createExecutor(-1);
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.parallelismState = context.getOperatorStateStore().getUnionListState(new ListStateDescriptor("parallelism", (TypeSerializer)IntSerializer.INSTANCE));
        OperatorStateUtils.getUniqueElement(this.parallelismState, "parallelism").ifPresent(oldParallelism -> Preconditions.checkState((oldParallelism.intValue() == this.getRuntimeContext().getNumberOfParallelSubtasks() ? 1 : 0) != 0, (Object)("The Replay operator is recovered with parallelism changed from " + oldParallelism + " to " + this.getRuntimeContext().getNumberOfParallelSubtasks())));
        this.currentEpochState = context.getOperatorStateStore().getListState(new ListStateDescriptor("epoch", (TypeSerializer)IntSerializer.INSTANCE));
        OperatorStateUtils.getUniqueElement(this.currentEpochState, "epoch").ifPresent(epoch -> {
            this.currentEpoch = epoch;
        });
        try {
            SupplierWithException<Path, IOException> pathGenerator = OperatorUtils.createDataCacheFileGenerator(this.basePath, "replay", this.config.getOperatorID());
            DataCacheSnapshot dataCacheSnapshot = null;
            List rawStateInputs = IteratorUtils.toList(context.getRawOperatorStateInputs().iterator());
            if (rawStateInputs.size() > 0) {
                Preconditions.checkState((rawStateInputs.size() == 1 ? 1 : 0) != 0, (Object)"Currently the replay operator does not support rescaling");
                dataCacheSnapshot = DataCacheSnapshot.recover(((StatePartitionStreamProvider)rawStateInputs.get(0)).getStream(), this.fileSystem, pathGenerator);
            }
            this.dataCacheWriter = new DataCacheWriter<T>(this.typeSerializer, this.fileSystem, pathGenerator, dataCacheSnapshot == null ? Collections.emptyList() : dataCacheSnapshot.getSegments());
            if (dataCacheSnapshot != null && dataCacheSnapshot.getReaderPosition() != null) {
                this.currentDataCacheReader = new DataCacheReader<T>(this.typeSerializer, dataCacheSnapshot.getSegments(), dataCacheSnapshot.getReaderPosition());
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to replay the records", (Throwable)e);
        }
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.parallelismState.clear();
        if (this.getRuntimeContext().getIndexOfThisSubtask() == 0) {
            this.parallelismState.update(Collections.singletonList(this.getRuntimeContext().getNumberOfParallelSubtasks()));
        }
        this.currentEpochState.update(Collections.singletonList(this.currentEpoch));
        this.dataCacheWriter.writeSegmentsToFiles();
        DataCacheSnapshot dataCacheSnapshot = new DataCacheSnapshot(this.fileSystem, this.currentDataCacheReader == null ? null : this.currentDataCacheReader.getPosition(), this.dataCacheWriter.getSegments());
        context.getRawOperatorStateOutput().startNewPartition();
        dataCacheSnapshot.writeTo((OutputStream)context.getRawOperatorStateOutput());
    }

    public void processElement1(StreamRecord<IterationRecord<T>> element) throws Exception {
        switch (((IterationRecord)element.getValue()).getType()) {
            case RECORD: {
                this.dataCacheWriter.addRecord(((IterationRecord)element.getValue()).getValue());
                this.output.collect(element);
                break;
            }
            case EPOCH_WATERMARK: {
                this.progressTracker.onEpochWatermark(0, ((IterationRecord)element.getValue()).getSender(), ((IterationRecord)element.getValue()).getEpoch());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported element type: " + element.getValue());
            }
        }
    }

    public void processElement2(StreamRecord<IterationRecord<Void>> element) throws Exception {
        if (((IterationRecord)element.getValue()).getType() != IterationRecord.Type.EPOCH_WATERMARK) {
            throw new UnsupportedOperationException("Not supported element type: " + element.getValue());
        }
        this.progressTracker.onEpochWatermark(1, ((IterationRecord)element.getValue()).getSender(), ((IterationRecord)element.getValue()).getEpoch());
    }

    public void endInput(int i) throws Exception {
        this.progressTracker.finish(i - 1);
        if (i == 1 && this.currentDataCacheReader != null) {
            this.replayRecords(this.currentDataCacheReader, this.currentEpoch);
        }
    }

    @Override
    public void onEpochWatermarkIncrement(int epochWatermark) throws IOException {
        if (epochWatermark == 0) {
            this.dataCacheWriter.finish();
            this.emitEpochWatermark(epochWatermark);
            return;
        }
        if (epochWatermark == Integer.MAX_VALUE) {
            this.emitEpochWatermark(epochWatermark);
            return;
        }
        Preconditions.checkState((this.currentDataCacheReader == null ? 1 : 0) != 0, (Object)"Concurrent replay is not supported");
        this.currentEpoch = epochWatermark;
        this.currentDataCacheReader = new DataCacheReader<T>(this.typeSerializer, this.dataCacheWriter.getSegments());
        this.replayRecords(this.currentDataCacheReader, epochWatermark);
    }

    private void replayRecords(DataCacheReader<T> dataCacheReader, int epoch) {
        StreamRecord reusable = new StreamRecord(IterationRecord.newRecord(null, epoch));
        while (dataCacheReader.hasNext()) {
            while (this.mailboxExecutor.tryYield()) {
            }
            T next = dataCacheReader.next();
            ((IterationRecord)reusable.getValue()).setValue(next);
            this.output.collect((Object)reusable);
        }
        this.currentDataCacheReader = null;
        this.emitEpochWatermark(epoch);
    }

    private void emitEpochWatermark(int epoch) {
        this.output.collect((Object)new StreamRecord(IterationRecord.newEpochWatermark(epoch, OperatorUtils.getUniqueSenderId(this.config.getOperatorID(), this.getContainingTask().getIndexInSubtaskGroup()))));
    }
}

