/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.iteration.IterationID;
import org.apache.flink.iteration.config.IterationOptions;
import org.apache.flink.iteration.proxy.ProxyKeySelector;
import org.apache.flink.iteration.utils.ReflectionUtils;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.statefun.flink.core.feedback.FeedbackChannel;
import org.apache.flink.statefun.flink.core.feedback.FeedbackConsumer;
import org.apache.flink.statefun.flink.core.feedback.FeedbackKey;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingConsumer;

public class OperatorUtils {
    public static String getUniqueSenderId(OperatorID operatorId, int subtaskIndex) {
        return operatorId.toHexString() + "-" + subtaskIndex;
    }

    public static <V> FeedbackKey<V> createFeedbackKey(IterationID iterationId, int feedbackIndex) {
        return new FeedbackKey(iterationId.toHexString(), (long)feedbackIndex);
    }

    public static <V> void registerFeedbackConsumer(FeedbackChannel<V> feedbackChannel, FeedbackConsumer<V> feedbackConsumer, Executor executor) {
        ReflectionUtils.callMethod(feedbackChannel, FeedbackChannel.class, "registerConsumer", Arrays.asList(FeedbackConsumer.class, Executor.class), Arrays.asList(feedbackConsumer, executor));
    }

    public static <T> void processOperatorOrUdfIfSatisfy(StreamOperator<?> operator, Class<T> targetInterface, ThrowingConsumer<T, Exception> action) {
        try {
            Function udf;
            if (targetInterface.isAssignableFrom(operator.getClass())) {
                action.accept(operator);
            } else if (operator instanceof AbstractUdfStreamOperator && targetInterface.isAssignableFrom((udf = ((AbstractUdfStreamOperator)operator).getUserFunction()).getClass())) {
                action.accept((Object)udf);
            }
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static StreamConfig createWrappedOperatorConfig(StreamConfig wrapperConfig, ClassLoader cl) {
        StreamConfig wrappedConfig = new StreamConfig(wrapperConfig.getConfiguration().clone());
        for (int i = 0; i < wrappedConfig.getNumberOfNetworkInputs(); ++i) {
            KeySelector keySelector = wrapperConfig.getStatePartitioner(i, cl);
            if (keySelector == null) continue;
            Preconditions.checkState((boolean)(keySelector instanceof ProxyKeySelector), (Object)("The state partitioner for the wrapper operator should always be ProxyKeySelector, but it is " + keySelector));
            wrappedConfig.setStatePartitioner(i, ((ProxyKeySelector)keySelector).getWrappedKeySelector());
        }
        return wrappedConfig;
    }

    public static Path getDataCachePath(Configuration configuration, String[] localSpillPaths) {
        String pathStr = (String)configuration.get(IterationOptions.DATA_CACHE_PATH);
        if (pathStr == null) {
            Random random = new Random();
            String localSpillPath = localSpillPaths[random.nextInt(localSpillPaths.length)];
            pathStr = Paths.get(localSpillPath, new String[0]).toUri().toString();
        }
        return new Path(pathStr);
    }

    public static SupplierWithException<Path, IOException> createDataCacheFileGenerator(Path basePath, String fileTypeName, OperatorID operatorId) {
        return () -> new Path(String.format("%s/%s-%s-%s", basePath.toString(), fileTypeName, operatorId, UUID.randomUUID().toString()));
    }
}

