/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.flink.iteration.IterationListener;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.broadcast.BroadcastOutput;
import org.apache.flink.iteration.broadcast.BroadcastOutputFactory;
import org.apache.flink.iteration.operator.OperatorUtils;
import org.apache.flink.iteration.progresstrack.OperatorEpochWatermarkTracker;
import org.apache.flink.iteration.progresstrack.OperatorEpochWatermarkTrackerFactory;
import org.apache.flink.iteration.progresstrack.OperatorEpochWatermarkTrackerListener;
import org.apache.flink.iteration.proxy.ProxyOutput;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.metrics.groups.InternalOperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWrapperOperator<T>
implements StreamOperator<IterationRecord<T>>,
OperatorEpochWatermarkTrackerListener,
BoundedMultiInput {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWrapperOperator.class);
    protected final StreamOperatorParameters<IterationRecord<T>> parameters;
    protected final StreamConfig streamConfig;
    protected final StreamTask<?, ?> containingTask;
    protected final Output<StreamRecord<IterationRecord<T>>> output;
    protected final StreamOperatorFactory<T> operatorFactory;
    protected final IterationContext iterationContext;
    protected final ProxyOutput<T> proxyOutput;
    protected final EpochSupplier epochWatermarkSupplier;
    protected final InternalOperatorMetricGroup metrics;
    protected final OperatorEpochWatermarkTracker epochWatermarkTracker;
    protected final String uniqueSenderId;
    protected final BroadcastOutput<IterationRecord<T>> eventBroadcastOutput;

    public AbstractWrapperOperator(StreamOperatorParameters<IterationRecord<T>> parameters, StreamOperatorFactory<T> operatorFactory) {
        this.parameters = Objects.requireNonNull(parameters);
        this.streamConfig = Objects.requireNonNull(parameters.getStreamConfig());
        this.containingTask = Objects.requireNonNull(parameters.getContainingTask());
        this.output = Objects.requireNonNull(parameters.getOutput());
        this.operatorFactory = Objects.requireNonNull(operatorFactory);
        this.proxyOutput = new ProxyOutput<T>(this.output);
        this.epochWatermarkSupplier = new EpochSupplier();
        this.metrics = this.createOperatorMetricGroup(this.containingTask.getEnvironment(), this.streamConfig);
        this.epochWatermarkTracker = OperatorEpochWatermarkTrackerFactory.create(this.streamConfig, this.containingTask, this);
        this.uniqueSenderId = OperatorUtils.getUniqueSenderId(this.streamConfig.getOperatorID(), this.containingTask.getIndexInSubtaskGroup());
        this.eventBroadcastOutput = BroadcastOutputFactory.createBroadcastOutput(this.output, this.metrics.getIOMetricGroup().getNumRecordsOutCounter());
        this.iterationContext = new IterationContext();
    }

    protected void onEpochWatermarkEvent(int inputIndex, IterationRecord<?> iterationRecord) throws IOException {
        Preconditions.checkState((iterationRecord.getType() == IterationRecord.Type.EPOCH_WATERMARK ? 1 : 0) != 0, (Object)("The record " + iterationRecord + " is not epoch watermark."));
        this.epochWatermarkTracker.onEpochWatermark(inputIndex, iterationRecord.getSender(), iterationRecord.getEpoch());
    }

    protected void notifyEpochWatermarkIncrement(IterationListener<?> listener, int epochWatermark) throws Exception {
        if (epochWatermark != Integer.MAX_VALUE) {
            listener.onEpochWatermarkIncremented(epochWatermark, this.iterationContext, (Collector<?>)new TimestampedCollector(this.proxyOutput));
        } else {
            listener.onIterationTerminated(this.iterationContext, (Collector<?>)new TimestampedCollector(this.proxyOutput));
        }
    }

    @Override
    public void onEpochWatermarkIncrement(int epochWatermark) throws IOException {
        this.eventBroadcastOutput.broadcastEmit(new StreamRecord(IterationRecord.newEpochWatermark(epochWatermark, this.uniqueSenderId)));
    }

    protected void setIterationContextRound(Integer contextRound) {
        this.proxyOutput.setContextRound(contextRound);
        this.epochWatermarkSupplier.set(contextRound);
    }

    protected void clearIterationContextRound() {
        this.proxyOutput.setContextRound(null);
        this.epochWatermarkSupplier.set(null);
    }

    public void endInput(int i) throws Exception {
        this.epochWatermarkTracker.finish(i - 1);
    }

    private InternalOperatorMetricGroup createOperatorMetricGroup(Environment environment, StreamConfig streamConfig) {
        try {
            InternalOperatorMetricGroup operatorMetricGroup = environment.getMetricGroup().getOrAddOperator(streamConfig.getOperatorID(), streamConfig.getOperatorName());
            if (streamConfig.isChainEnd()) {
                operatorMetricGroup.getIOMetricGroup().reuseOutputMetricsForTask();
            }
            return operatorMetricGroup;
        }
        catch (Exception e) {
            LOG.warn("An error occurred while instantiating task metrics.", (Throwable)e);
            return UnregisteredMetricGroups.createUnregisteredOperatorMetricGroup();
        }
    }

    private static class EpochSupplier
    implements Supplier<Integer> {
        private Integer epoch;

        private EpochSupplier() {
        }

        public void set(Integer epoch) {
            this.epoch = epoch;
        }

        @Override
        public Integer get() {
            return this.epoch;
        }
    }

    private class IterationContext
    implements IterationListener.Context {
        private IterationContext() {
        }

        @Override
        public <X> void output(OutputTag<X> outputTag, X value) {
            AbstractWrapperOperator.this.proxyOutput.collect(outputTag, new StreamRecord(value));
        }
    }
}

