/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.datacache.nonkeyed;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.iteration.datacache.nonkeyed.Segment;
import org.apache.flink.iteration.datacache.nonkeyed.SegmentReader;

@Internal
class MemorySegmentReader<T>
implements SegmentReader<T> {
    private final TypeSerializer<T> serializer;
    private final DataInputView inputView;
    private final int totalCount;
    private int count;

    MemorySegmentReader(TypeSerializer<T> serializer, Segment segment, int startOffset) throws IOException {
        ManagedMemoryInputStream inputStream = new ManagedMemoryInputStream(segment.getCache());
        this.inputView = new DataInputViewStreamWrapper((InputStream)inputStream);
        this.serializer = serializer;
        this.totalCount = segment.getCount();
        this.count = 0;
        for (int i = 0; i < startOffset; ++i) {
            this.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.count < this.totalCount;
    }

    @Override
    public T next() throws IOException {
        Object value = this.serializer.deserialize(this.inputView);
        ++this.count;
        return (T)value;
    }

    @Override
    public void close() {
    }

    private static class ManagedMemoryInputStream
    extends InputStream {
        private final List<MemorySegment> segments;
        private int segmentIndex;
        private int segmentOffset;

        public ManagedMemoryInputStream(List<MemorySegment> segments) {
            this.segments = segments;
            this.segmentIndex = 0;
            this.segmentOffset = 0;
        }

        @Override
        public int read() throws IOException {
            int ret = this.segments.get(this.segmentIndex).get(this.segmentOffset) & 0xFF;
            ++this.segmentOffset;
            if (this.segmentOffset >= this.segments.get(this.segmentIndex).size()) {
                ++this.segmentIndex;
                this.segmentOffset = 0;
            }
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int readLen = 0;
            while (len > 0 && this.segmentIndex < this.segments.size()) {
                int currentLen = Math.min(this.segments.get(this.segmentIndex).size() - this.segmentOffset, len);
                this.segments.get(this.segmentIndex).get(this.segmentOffset, b, off, currentLen);
                this.segmentOffset += currentLen;
                if (this.segmentOffset >= this.segments.get(this.segmentIndex).size()) {
                    ++this.segmentIndex;
                    this.segmentOffset = 0;
                }
                readLen += currentLen;
                off += currentLen;
                len -= currentLen;
            }
            return readLen;
        }
    }
}

