/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.checkpoint;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.iteration.checkpoint.Checkpoints;
import org.apache.flink.statefun.flink.core.feedback.SubtaskFeedbackKey;

public class CheckpointsBroker {
    private static final CheckpointsBroker INSTANCE = new CheckpointsBroker();
    private final ConcurrentHashMap<SubtaskFeedbackKey<?>, Checkpoints<?>> checkpointManagers = new ConcurrentHashMap();

    public static CheckpointsBroker get() {
        return INSTANCE;
    }

    public <V> void setCheckpoints(SubtaskFeedbackKey<V> key, Checkpoints<V> checkpoints) {
        this.checkpointManagers.put(key, checkpoints);
    }

    public <V> Checkpoints<V> getCheckpoints(SubtaskFeedbackKey<V> key) {
        Objects.requireNonNull(key);
        return Objects.requireNonNull(this.checkpointManagers.get(key));
    }

    void removeChannel(SubtaskFeedbackKey<?> key) {
        this.checkpointManagers.remove(key);
    }
}

