/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import org.apache.flink.ml.feature.bucketizer.Bucketizer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class BucketizerExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{-0.5, 0.0, 1.0, 0.0})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("f1", new String[]{"f2", "f3", "f4"});
        Double[][] splitsArray = new Double[][]{{-0.5, 0.0, 0.5}, {-1.0, 0.0, 2.0}, {Double.NEGATIVE_INFINITY, 10.0, Double.POSITIVE_INFINITY}, {Double.NEGATIVE_INFINITY, 1.5, Double.POSITIVE_INFINITY}};
        Bucketizer bucketizer = (Bucketizer)((Bucketizer)((Bucketizer)((Bucketizer)new Bucketizer().setInputCols(new String[]{"f1", "f2", "f3", "f4"})).setOutputCols(new String[]{"o1", "o2", "o3", "o4"})).setSplitsArray(splitsArray)).setHandleInvalid("skip");
        Table outputTable = bucketizer.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            double[] inputValues = new double[bucketizer.getInputCols().length];
            double[] outputValues = new double[bucketizer.getInputCols().length];
            for (int i = 0; i < inputValues.length; ++i) {
                inputValues[i] = (Double)row.getField(bucketizer.getInputCols()[i]);
                outputValues[i] = (Double)row.getField(bucketizer.getOutputCols()[i]);
            }
            System.out.printf("Input Values: %s\tOutput Values: %s\n", Arrays.toString(inputValues), Arrays.toString(outputValues));
        }
    }
}

