/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.classification;

import org.apache.flink.ml.classification.knn.Knn;
import org.apache.flink.ml.classification.knn.KnnModel;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class KnnExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource trainStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.0, 3.0}), 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.1, 3.1}), 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{200.1, 300.1}), 2.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{200.2, 300.2}), 2.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{200.3, 300.3}), 2.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{200.4, 300.4}), 2.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{200.4, 300.4}), 2.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{200.6, 300.6}), 2.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.1, 3.1}), 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.1, 3.1}), 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.1, 3.1}), 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.1, 3.1}), 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.3, 3.2}), 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.3, 3.2}), 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.8, 3.2}), 3.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{300.0, 3.2}), 4.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.2, 3.2}), 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.4, 3.2}), 5.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.5, 3.2}), 5.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.5, 3.2}), 5.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.1, 3.1}), 1.0})});
        Table trainTable = tEnv.fromDataStream((DataStream)trainStream).as("features", new String[]{"label"});
        DataStreamSource predictStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{4.0, 4.1}), 5.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{300.0, 42.0}), 2.0})});
        Table predictTable = tEnv.fromDataStream((DataStream)predictStream).as("features", new String[]{"label"});
        Knn knn = (Knn)new Knn().setK(Integer.valueOf(4));
        KnnModel knnModel = knn.fit(new Table[]{trainTable});
        Table outputTable = knnModel.transform(new Table[]{predictTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            DenseVector features = (DenseVector)row.getField(knn.getFeaturesCol());
            double expectedResult = (Double)row.getField(knn.getLabelCol());
            double predictionResult = (Double)row.getField(knn.getPredictionCol());
            System.out.printf("Features: %-15s \tExpected Result: %s \tPrediction Result: %s\n", features, expectedResult, predictionResult);
        }
    }
}

