/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.ml.Functions;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class ArrayToVectorExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        List doubleArrays = Arrays.asList({0.0, 0.0}, {0.0, 1.0});
        Table inputTable = tEnv.fromDataStream((DataStream)env.fromCollection(doubleArrays)).as("array", new String[0]);
        Table outputTable = inputTable.select(new Expression[]{Expressions.$((String)"array"), (Expression)Functions.arrayToVector((Object[])new Object[]{Expressions.$((String)"array")}).as("vector", new String[0])});
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Object[] doubleArray = (Double[])row.getFieldAs("array");
            Vector vector = (Vector)row.getFieldAs("vector");
            System.out.printf("Input double array: %s\tOutput vector: %s\n", Arrays.toString(doubleArray), vector);
        }
    }
}

