/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.state;

import java.util.Objects;
import org.apache.flink.statefun.flink.core.di.Inject;
import org.apache.flink.statefun.flink.core.state.State;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.statefun.sdk.state.Accessor;
import org.apache.flink.statefun.sdk.state.ApiExtension;
import org.apache.flink.statefun.sdk.state.AppendingBufferAccessor;
import org.apache.flink.statefun.sdk.state.PersistedAppendingBuffer;
import org.apache.flink.statefun.sdk.state.PersistedTable;
import org.apache.flink.statefun.sdk.state.PersistedValue;
import org.apache.flink.statefun.sdk.state.RemotePersistedValue;
import org.apache.flink.statefun.sdk.state.StateBinder;
import org.apache.flink.statefun.sdk.state.TableAccessor;

public final class FlinkStateBinder
extends StateBinder {
    private final State state;
    private final FunctionType functionType;

    @Inject
    public FlinkStateBinder(State state, FunctionType functionType) {
        this.state = Objects.requireNonNull(state);
        this.functionType = Objects.requireNonNull(functionType);
    }

    public void bind(Object stateObject) {
        if (stateObject instanceof PersistedValue) {
            this.bindValue((PersistedValue)stateObject);
        } else if (stateObject instanceof PersistedTable) {
            this.bindTable((PersistedTable)stateObject);
        } else if (stateObject instanceof PersistedAppendingBuffer) {
            this.bindAppendingBuffer((PersistedAppendingBuffer)stateObject);
        } else if (stateObject instanceof RemotePersistedValue) {
            this.bindRemoteValue((RemotePersistedValue)stateObject);
        } else {
            throw new IllegalArgumentException("Unknown persisted state object " + stateObject);
        }
    }

    private void bindValue(PersistedValue<?> persistedValue) {
        Accessor<?> accessor = this.state.createFlinkStateAccessor(this.functionType, persistedValue);
        FlinkStateBinder.setAccessorRaw(persistedValue, accessor);
    }

    private void bindTable(PersistedTable<?, ?> persistedTable) {
        TableAccessor<?, ?> accessor = this.state.createFlinkStateTableAccessor(this.functionType, persistedTable);
        this.setAccessorRaw(persistedTable, accessor);
    }

    private void bindAppendingBuffer(PersistedAppendingBuffer<?> persistedAppendingBuffer) {
        AppendingBufferAccessor<?> accessor = this.state.createFlinkStateAppendingBufferAccessor(this.functionType, persistedAppendingBuffer);
        FlinkStateBinder.setAccessorRaw(persistedAppendingBuffer, accessor);
    }

    private void bindRemoteValue(RemotePersistedValue remotePersistedValue) {
        Accessor<byte[]> accessor = this.state.createFlinkRemoteStateAccessor(this.functionType, remotePersistedValue);
        FlinkStateBinder.setAccessorRaw(remotePersistedValue, accessor);
    }

    private void setAccessorRaw(PersistedTable<?, ?> persistedTable, TableAccessor<?, ?> accessor) {
        ApiExtension.setPersistedTableAccessor(persistedTable, accessor);
    }

    private static void setAccessorRaw(PersistedValue<?> persistedValue, Accessor<?> accessor) {
        ApiExtension.setPersistedValueAccessor(persistedValue, accessor);
    }

    private static void setAccessorRaw(PersistedAppendingBuffer<?> persistedAppendingBuffer, AppendingBufferAccessor<?> accessor) {
        ApiExtension.setPersistedAppendingBufferAccessor(persistedAppendingBuffer, accessor);
    }

    private static void setAccessorRaw(RemotePersistedValue remotePersistedValue, Accessor<byte[]> accessor) {
        ApiExtension.setRemotePersistedValueAccessor(remotePersistedValue, accessor);
    }
}

