/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.spi;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;

public class ModuleSpecs
implements Iterable<ModuleSpec>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ModuleSpec> specs;

    private ModuleSpecs(List<ModuleSpec> specs) {
        this.specs = Objects.requireNonNull(specs);
    }

    public static ModuleSpecs fromPath(String rootDirectory) throws IOException {
        Objects.requireNonNull(rootDirectory);
        List<ModuleSpec> loadableModules = ModuleSpecs.discoverLoadableArtifacts(rootDirectory);
        return new ModuleSpecs(loadableModules);
    }

    public static ModuleSpecs fromCollection(ModuleSpec ... moduleSpecs) {
        List<ModuleSpec> loadableModules = Arrays.asList(moduleSpecs);
        return new ModuleSpecs(loadableModules);
    }

    private static List<ModuleSpec> discoverLoadableArtifacts(String rootDirectory) throws IOException {
        File parent = new File(rootDirectory);
        if (!parent.exists()) {
            throw new IllegalArgumentException(rootDirectory + " does not exists.");
        }
        if (!parent.isDirectory()) {
            throw new RuntimeException(rootDirectory + " is not a directory.");
        }
        ArrayList<ModuleSpec> loadableFunctions = new ArrayList<ModuleSpec>();
        for (File subDirectory : ModuleSpecs.nullToEmpty(parent.listFiles())) {
            if (!subDirectory.isDirectory()) continue;
            ModuleSpec loadableFunction = ModuleSpecs.findLoadableModuleArtifacts(subDirectory.getAbsoluteFile());
            loadableFunctions.add(loadableFunction);
        }
        return loadableFunctions;
    }

    private static ModuleSpec findLoadableModuleArtifacts(File subDirectory) throws IOException {
        ModuleSpec.Builder builder = ModuleSpec.builder();
        for (File file : ModuleSpecs.nullToEmpty(subDirectory.listFiles())) {
            if (!file.isFile()) continue;
            if (file.getName().endsWith(".jar")) {
                builder.withJarFile(file.getAbsoluteFile());
                continue;
            }
            if (!file.getName().equals("module.yaml")) continue;
            builder.withYamlModuleFile(subDirectory.getAbsoluteFile());
        }
        return builder.build();
    }

    private static File[] nullToEmpty(File[] elements) {
        return elements == null ? new File[]{} : elements;
    }

    public List<ModuleSpec> modules() {
        return this.specs;
    }

    @Override
    public Iterator<ModuleSpec> iterator() {
        return this.specs.iterator();
    }

    public static final class ModuleSpec
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<URI> artifactUrls;

        private ModuleSpec(List<URI> artifacts) {
            this.artifactUrls = Collections.unmodifiableList(artifacts);
        }

        static Builder builder() {
            return new Builder();
        }

        public List<URI> artifactUris() {
            return this.artifactUrls;
        }

        static final class Builder {
            private final TreeSet<URI> artifacts = new TreeSet();

            Builder() {
            }

            Builder withYamlModuleFile(File file) throws IOException {
                Objects.requireNonNull(file);
                this.artifacts.add(file.getCanonicalFile().toURI());
                return this;
            }

            Builder withJarFile(File file) throws IOException {
                Objects.requireNonNull(file);
                this.artifacts.add(file.getCanonicalFile().toURI());
                return this;
            }

            Builder withUri(URI uri) {
                Objects.requireNonNull(uri);
                this.artifacts.add(uri);
                return this;
            }

            ModuleSpec build() {
                ArrayList<URI> sortedCopy = new ArrayList<URI>(this.artifacts);
                return new ModuleSpec(sortedCopy);
            }
        }
    }
}

