/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.nettyclient;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPipeline;
import org.apache.flink.shaded.netty4.io.netty.channel.pool.ChannelPoolHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpClientCodec;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpContentDecompressor;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpObjectAggregator;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslContext;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.statefun.flink.core.nettyclient.ChannelAttributes;
import org.apache.flink.statefun.flink.core.nettyclient.HttpConnectionPoolHandler;
import org.apache.flink.statefun.flink.core.nettyclient.NettyRequestReplyHandler;
import org.apache.flink.statefun.flink.core.nettyclient.NettyRequestReplySpec;

final class HttpConnectionPoolManager
implements ChannelPoolHandler {
    private final NettyRequestReplySpec spec;
    private final SslContext sslContext;
    private final String peerHost;
    private final int peerPort;

    public HttpConnectionPoolManager(@Nullable SslContext sslContext, NettyRequestReplySpec spec, String peerHost, int peerPort) {
        this.spec = Objects.requireNonNull(spec);
        this.peerHost = Objects.requireNonNull(peerHost);
        this.sslContext = sslContext;
        this.peerPort = peerPort;
    }

    public void channelAcquired(Channel channel) {
        channel.attr(ChannelAttributes.ACQUIRED).set((Object)Boolean.TRUE);
    }

    public void channelReleased(Channel channel) {
        channel.attr(ChannelAttributes.ACQUIRED).set((Object)Boolean.FALSE);
        NettyRequestReplyHandler handler = (NettyRequestReplyHandler)channel.pipeline().get(NettyRequestReplyHandler.class);
        handler.onReleaseToPool();
    }

    public void channelCreated(Channel channel) {
        ChannelPipeline p = channel.pipeline();
        if (this.sslContext != null) {
            SslHandler sslHandler = this.sslContext.newHandler(channel.alloc(), this.peerHost, this.peerPort);
            p.addLast(new ChannelHandler[]{sslHandler});
        }
        p.addLast(new ChannelHandler[]{new HttpClientCodec()});
        p.addLast(new ChannelHandler[]{new HttpContentDecompressor(true)});
        p.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.spec.maxRequestOrResponseSizeInBytes, true)});
        p.addLast(new ChannelHandler[]{new NettyRequestReplyHandler()});
        long channelTimeToLiveMillis = this.spec.pooledConnectionTTL.toMillis();
        p.addLast(new ChannelHandler[]{new HttpConnectionPoolHandler(channelTimeToLiveMillis)});
    }
}

