/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.metrics;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashMap;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.statefun.flink.core.metrics.FlinkMetricUtil;
import org.apache.flink.statefun.sdk.metrics.Counter;
import org.apache.flink.statefun.sdk.metrics.Metrics;

@Internal
public final class FlinkUserMetrics
implements Metrics {
    private final ObjectOpenHashMap<String, Counter> counters = new ObjectOpenHashMap();
    private final MetricGroup typeGroup;

    public FlinkUserMetrics(MetricGroup typeGroup) {
        this.typeGroup = Objects.requireNonNull(typeGroup);
    }

    public Counter counter(String name) {
        Objects.requireNonNull(name);
        Counter counter = this.counters.get(name);
        if (counter == null) {
            SimpleCounter internalCounter = (SimpleCounter)this.typeGroup.counter(name, (org.apache.flink.metrics.Counter)new SimpleCounter());
            counter = FlinkMetricUtil.wrapFlinkCounterAsSdkCounter((org.apache.flink.metrics.Counter)internalCounter);
            this.counters.put(name, counter);
        }
        return counter;
    }
}

