/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.httpfn.binders.v1;

import java.util.OptionalInt;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonPointer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.statefun.extensions.ComponentBinder;
import org.apache.flink.statefun.extensions.ComponentJsonObject;
import org.apache.flink.statefun.flink.common.json.Selectors;
import org.apache.flink.statefun.flink.core.httpfn.DefaultHttpRequestReplyClientFactory;
import org.apache.flink.statefun.flink.core.httpfn.HttpFunctionEndpointSpec;
import org.apache.flink.statefun.flink.core.httpfn.HttpFunctionProvider;
import org.apache.flink.statefun.flink.core.httpfn.TargetFunctions;
import org.apache.flink.statefun.flink.core.httpfn.TransportClientConstants;
import org.apache.flink.statefun.flink.core.httpfn.TransportClientSpec;
import org.apache.flink.statefun.flink.core.httpfn.UrlPathTemplate;
import org.apache.flink.statefun.sdk.StatefulFunctionProvider;
import org.apache.flink.statefun.sdk.TypeName;
import org.apache.flink.statefun.sdk.spi.StatefulFunctionModule;

public final class HttpEndpointBinderV1
implements ComponentBinder {
    static final HttpEndpointBinderV1 INSTANCE = new HttpEndpointBinderV1();
    public static final TypeName KIND_TYPE = TypeName.parseFrom((String)"io.statefun.endpoints.v1/http");
    private static final JsonPointer TARGET_FUNCTIONS = JsonPointer.compile((String)"/functions");
    private static final JsonPointer URL_PATH_TEMPLATE = JsonPointer.compile((String)"/urlPathTemplate");
    private static final JsonPointer MAX_NUM_BATCH_REQUESTS = JsonPointer.compile((String)"/maxNumBatchRequests");

    private HttpEndpointBinderV1() {
    }

    public void bind(ComponentJsonObject component, StatefulFunctionModule.Binder binder) {
        HttpEndpointBinderV1.validateComponent(component);
        HttpFunctionEndpointSpec spec = HttpEndpointBinderV1.parseSpec(component);
        HttpFunctionProvider provider = new HttpFunctionProvider(spec, DefaultHttpRequestReplyClientFactory.INSTANCE);
        TargetFunctions target = spec.targetFunctions();
        if (target.isSpecificFunctionType()) {
            binder.bindFunctionProvider(target.asSpecificFunctionType(), (StatefulFunctionProvider)provider);
        } else {
            binder.bindFunctionProvider(target.asNamespace(), (StatefulFunctionProvider)provider);
        }
    }

    private static void validateComponent(ComponentJsonObject componentJsonObject) {
        TypeName targetBinderType = componentJsonObject.binderTypename();
        if (!targetBinderType.equals((Object)KIND_TYPE)) {
            throw new IllegalStateException("Received unexpected ModuleComponent to bind: " + componentJsonObject);
        }
    }

    private static HttpFunctionEndpointSpec parseSpec(ComponentJsonObject component) {
        JsonNode httpEndpointSpecNode = component.specJsonNode();
        HttpFunctionEndpointSpec.Builder specBuilder = HttpFunctionEndpointSpec.builder(HttpEndpointBinderV1.target(httpEndpointSpecNode), HttpEndpointBinderV1.urlPathTemplate(httpEndpointSpecNode));
        HttpEndpointBinderV1.optionalMaxNumBatchRequests(httpEndpointSpecNode).ifPresent(specBuilder::withMaxNumBatchRequests);
        TransportClientSpec transportClientSpec = new TransportClientSpec(TransportClientConstants.OKHTTP_CLIENT_FACTORY_TYPE, (ObjectNode)httpEndpointSpecNode);
        specBuilder.withTransport(transportClientSpec);
        return specBuilder.build();
    }

    private static TargetFunctions target(JsonNode functionEndpointSpecNode) {
        String targetPatternString = Selectors.textAt((JsonNode)functionEndpointSpecNode, (JsonPointer)TARGET_FUNCTIONS);
        return TargetFunctions.fromPatternString(targetPatternString);
    }

    private static UrlPathTemplate urlPathTemplate(JsonNode functionEndpointSpecNode) {
        String template = Selectors.textAt((JsonNode)functionEndpointSpecNode, (JsonPointer)URL_PATH_TEMPLATE);
        return new UrlPathTemplate(template);
    }

    private static OptionalInt optionalMaxNumBatchRequests(JsonNode functionNode) {
        return Selectors.optionalIntegerAt((JsonNode)functionNode, (JsonPointer)MAX_NUM_BATCH_REQUESTS);
    }
}

