/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.feedback;

import java.util.Objects;
import java.util.function.LongFunction;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.statefun.flink.core.feedback.FeedbackChannel;
import org.apache.flink.statefun.flink.core.feedback.FeedbackChannelBroker;
import org.apache.flink.statefun.flink.core.feedback.FeedbackKey;
import org.apache.flink.statefun.flink.core.feedback.SubtaskFeedbackKey;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.IOUtils;

public final class FeedbackSinkOperator<V>
extends AbstractStreamOperator<Void>
implements OneInputStreamOperator<V, Void> {
    private static final long serialVersionUID = 1L;
    private final FeedbackKey<V> key;
    private final LongFunction<V> barrierSentinelSupplier;
    private transient FeedbackChannel<V> channel;
    private transient SimpleCounter totalProduced;

    public FeedbackSinkOperator(FeedbackKey<V> key, LongFunction<V> barrierSentinelSupplier) {
        this.key = Objects.requireNonNull(key);
        this.barrierSentinelSupplier = Objects.requireNonNull(barrierSentinelSupplier);
    }

    public void processElement(StreamRecord<V> record) {
        Object value = record.getValue();
        this.channel.put(value);
        this.totalProduced.inc();
    }

    public void open() throws Exception {
        super.open();
        int indexOfThisSubtask = this.getRuntimeContext().getIndexOfThisSubtask();
        int attemptNum = this.getRuntimeContext().getAttemptNumber();
        SubtaskFeedbackKey<V> key = this.key.withSubTaskIndex(indexOfThisSubtask, attemptNum);
        FeedbackChannelBroker broker = FeedbackChannelBroker.get();
        this.channel = broker.getChannel(key);
        OperatorMetricGroup metrics = this.getRuntimeContext().getMetricGroup();
        SimpleCounter produced = (SimpleCounter)metrics.counter("produced", (Counter)new SimpleCounter());
        metrics.meter("producedRate", (Meter)new MeterView((Counter)produced, 60));
        this.totalProduced = produced;
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        super.prepareSnapshotPreBarrier(checkpointId);
        V sentinel = this.barrierSentinelSupplier.apply(checkpointId);
        this.channel.put(sentinel);
    }

    public void close() throws Exception {
        IOUtils.closeQuietly(this.channel);
        super.close();
    }
}

