/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.statefun.extensions.ExtensionModule;
import org.apache.flink.statefun.flink.core.message.MessageFactoryKey;
import org.apache.flink.statefun.flink.core.spi.ExtensionResolver;
import org.apache.flink.statefun.flink.core.types.StaticallyRegisteredTypes;
import org.apache.flink.statefun.flink.io.spi.FlinkIoModule;
import org.apache.flink.statefun.flink.io.spi.SinkProvider;
import org.apache.flink.statefun.flink.io.spi.SourceProvider;
import org.apache.flink.statefun.sdk.EgressType;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.statefun.sdk.FunctionTypeNamespaceMatcher;
import org.apache.flink.statefun.sdk.IngressType;
import org.apache.flink.statefun.sdk.StatefulFunctionProvider;
import org.apache.flink.statefun.sdk.TypeName;
import org.apache.flink.statefun.sdk.io.EgressIdentifier;
import org.apache.flink.statefun.sdk.io.EgressSpec;
import org.apache.flink.statefun.sdk.io.IngressIdentifier;
import org.apache.flink.statefun.sdk.io.IngressSpec;
import org.apache.flink.statefun.sdk.io.Router;
import org.apache.flink.statefun.sdk.spi.StatefulFunctionModule;

public final class StatefulFunctionsUniverse
implements StatefulFunctionModule.Binder,
FlinkIoModule.Binder,
ExtensionModule.Binder,
ExtensionResolver {
    private final Map<IngressIdentifier<?>, IngressSpec<?>> ingress = new HashMap();
    private final Map<EgressIdentifier<?>, EgressSpec<?>> egress = new HashMap();
    private final Map<IngressIdentifier<?>, List<Router<?>>> routers = new HashMap();
    private final Map<FunctionType, StatefulFunctionProvider> specificFunctionProviders = new HashMap<FunctionType, StatefulFunctionProvider>();
    private final Map<String, StatefulFunctionProvider> namespaceFunctionProviders = new HashMap<String, StatefulFunctionProvider>();
    private final Map<IngressType, SourceProvider> sources = new HashMap<IngressType, SourceProvider>();
    private final Map<EgressType, SinkProvider> sinks = new HashMap<EgressType, SinkProvider>();
    private final Map<TypeName, Object> extensions = new HashMap<TypeName, Object>();
    private final StaticallyRegisteredTypes types;
    private final MessageFactoryKey messageFactoryKey;

    public StatefulFunctionsUniverse(MessageFactoryKey messageFactoryKey) {
        this.messageFactoryKey = messageFactoryKey;
        this.types = new StaticallyRegisteredTypes(messageFactoryKey);
    }

    public <T> void bindIngress(IngressSpec<T> spec) {
        Objects.requireNonNull(spec);
        IngressIdentifier id = spec.id();
        StatefulFunctionsUniverse.putAndThrowIfPresent(this.ingress, id, spec);
    }

    public <T> void bindIngressRouter(IngressIdentifier<T> ingressIdentifier, Router<T> router) {
        Objects.requireNonNull(ingressIdentifier);
        Objects.requireNonNull(router);
        List ingressRouters = this.routers.computeIfAbsent(ingressIdentifier, unused -> new ArrayList());
        ingressRouters.add(router);
    }

    public <T> void bindEgress(EgressSpec<T> spec) {
        Objects.requireNonNull(spec);
        EgressIdentifier id = spec.id();
        StatefulFunctionsUniverse.putAndThrowIfPresent(this.egress, id, spec);
    }

    public void bindFunctionProvider(FunctionType functionType, StatefulFunctionProvider provider) {
        Objects.requireNonNull(functionType);
        Objects.requireNonNull(provider);
        StatefulFunctionsUniverse.putAndThrowIfPresent(this.specificFunctionProviders, functionType, provider);
    }

    public void bindFunctionProvider(FunctionTypeNamespaceMatcher namespaceMatcher, StatefulFunctionProvider provider) {
        Objects.requireNonNull(namespaceMatcher);
        Objects.requireNonNull(provider);
        StatefulFunctionsUniverse.putAndThrowIfPresent(this.namespaceFunctionProviders, namespaceMatcher.targetNamespace(), provider);
    }

    public void bindSourceProvider(IngressType type, SourceProvider provider) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(provider);
        StatefulFunctionsUniverse.putAndThrowIfPresent(this.sources, type, provider);
    }

    public void bindSinkProvider(EgressType type, SinkProvider provider) {
        StatefulFunctionsUniverse.putAndThrowIfPresent(this.sinks, type, provider);
    }

    public <T> void bindExtension(TypeName typeName, T extension) {
        StatefulFunctionsUniverse.putAndThrowIfPresent(this.extensions, typeName, extension);
    }

    @Override
    public <T> T resolveExtension(TypeName typeName, Class<T> extensionClass) {
        Object rawTypedExtension = this.extensions.get(typeName);
        if (rawTypedExtension == null) {
            throw new IllegalStateException("An extension with type " + typeName + " does not exist.");
        }
        if (rawTypedExtension.getClass().isAssignableFrom(extensionClass)) {
            throw new IllegalStateException("Unexpected class for extension " + typeName + "; expected " + extensionClass + ", but was " + rawTypedExtension.getClass());
        }
        return extensionClass.cast(rawTypedExtension);
    }

    public Map<IngressIdentifier<?>, IngressSpec<?>> ingress() {
        return this.ingress;
    }

    public Map<EgressIdentifier<?>, EgressSpec<?>> egress() {
        return this.egress;
    }

    public Map<IngressIdentifier<?>, List<Router<?>>> routers() {
        return this.routers;
    }

    public Map<FunctionType, StatefulFunctionProvider> functions() {
        return this.specificFunctionProviders;
    }

    public Map<String, StatefulFunctionProvider> namespaceFunctions() {
        return this.namespaceFunctionProviders;
    }

    public Map<IngressType, SourceProvider> sources() {
        return this.sources;
    }

    public Map<EgressType, SinkProvider> sinks() {
        return this.sinks;
    }

    public Map<TypeName, Object> getExtensions() {
        return this.extensions;
    }

    public StaticallyRegisteredTypes types() {
        return this.types;
    }

    private static <K, V> void putAndThrowIfPresent(Map<K, V> map, K key, V value) {
        V previous = map.put(key, value);
        if (previous == null) {
            return;
        }
        throw new IllegalStateException(String.format("A binding for the key %s was previously defined.", key));
    }

    public MessageFactoryKey messageFactoryKey() {
        return this.messageFactoryKey;
    }
}

