/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.python;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.python.shaded.net.razorvine.pickle.Pickler;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.typeinfo.python.PickledByteArrayTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class PythonBridgeUtils {
    public static Object getPickledBytesFromJavaObject(Object obj, TypeInformation<?> dataType) throws IOException {
        Pickler pickler = new Pickler();
        org.apache.flink.api.common.python.PythonBridgeUtils.getPickledBytesFromJavaObject(null, null);
        if (obj == null) {
            return pickler.dumps(null);
        }
        if (dataType instanceof SqlTimeTypeInfo) {
            SqlTimeTypeInfo sqlTimeTypeInfo = SqlTimeTypeInfo.getInfoFor((Class)dataType.getTypeClass());
            if (sqlTimeTypeInfo == SqlTimeTypeInfo.DATE) {
                return pickler.dumps((Object)((Date)obj).toLocalDate().toEpochDay());
            }
            if (sqlTimeTypeInfo == SqlTimeTypeInfo.TIME) {
                return pickler.dumps((Object)(((Time)obj).toLocalTime().toNanoOfDay() / 1000L));
            }
        } else {
            if (dataType instanceof RowTypeInfo || dataType instanceof TupleTypeInfo) {
                TypeInformation[] fieldTypes = ((TupleTypeInfoBase)dataType).getFieldTypes();
                int arity = dataType instanceof RowTypeInfo ? ((Row)obj).getArity() : ((Tuple)obj).getArity();
                ArrayList<Object> fieldBytes = new ArrayList<Object>(arity + 1);
                if (dataType instanceof RowTypeInfo) {
                    fieldBytes.add(new byte[]{((Row)obj).getKind().toByteValue()});
                }
                for (int i = 0; i < arity; ++i) {
                    Object field = dataType instanceof RowTypeInfo ? ((Row)obj).getField(i) : ((Tuple)obj).getField(i);
                    fieldBytes.add(PythonBridgeUtils.getPickledBytesFromJavaObject(field, fieldTypes[i]));
                }
                return fieldBytes;
            }
            if (dataType instanceof BasicArrayTypeInfo || dataType instanceof PrimitiveArrayTypeInfo || dataType instanceof ObjectArrayTypeInfo) {
                TypeInformation elementType;
                Object[] objects;
                if (dataType instanceof BasicArrayTypeInfo) {
                    objects = (Object[])obj;
                    elementType = ((BasicArrayTypeInfo)dataType).getComponentInfo();
                } else if (dataType instanceof PrimitiveArrayTypeInfo) {
                    objects = PythonBridgeUtils.primitiveArrayConverter(obj, dataType);
                    elementType = ((PrimitiveArrayTypeInfo)dataType).getComponentType();
                } else {
                    objects = (Object[])obj;
                    elementType = ((ObjectArrayTypeInfo)dataType).getComponentInfo();
                }
                ArrayList<Object> serializedElements = new ArrayList<Object>(objects.length);
                for (Object object : objects) {
                    serializedElements.add(PythonBridgeUtils.getPickledBytesFromJavaObject(object, elementType));
                }
                return pickler.dumps(serializedElements);
            }
            if (dataType instanceof MapTypeInfo) {
                ArrayList serializedMapKV = new ArrayList(2);
                Map mapObj = (Map)obj;
                ArrayList<Object> keyBytesList = new ArrayList<Object>(mapObj.size());
                ArrayList<Object> valueBytesList = new ArrayList<Object>(mapObj.size());
                for (Map.Entry entry : mapObj.entrySet()) {
                    keyBytesList.add(PythonBridgeUtils.getPickledBytesFromJavaObject(entry.getKey(), ((MapTypeInfo)dataType).getKeyTypeInfo()));
                    valueBytesList.add(PythonBridgeUtils.getPickledBytesFromJavaObject(entry.getValue(), ((MapTypeInfo)dataType).getValueTypeInfo()));
                }
                serializedMapKV.add(keyBytesList);
                serializedMapKV.add(valueBytesList);
                return pickler.dumps(serializedMapKV);
            }
            if (dataType instanceof ListTypeInfo) {
                List objects = (List)obj;
                ArrayList<Object> serializedElements = new ArrayList<Object>(objects.size());
                TypeInformation elementType = ((ListTypeInfo)dataType).getElementTypeInfo();
                for (Object object : objects) {
                    serializedElements.add(PythonBridgeUtils.getPickledBytesFromJavaObject(object, elementType));
                }
                return pickler.dumps(serializedElements);
            }
        }
        if (dataType instanceof BasicTypeInfo && BasicTypeInfo.getInfoFor((Class)dataType.getTypeClass()) == BasicTypeInfo.FLOAT_TYPE_INFO) {
            return pickler.dumps((Object)String.valueOf(obj));
        }
        if (dataType instanceof PickledByteArrayTypeInfo || dataType instanceof BasicTypeInfo) {
            return pickler.dumps(obj);
        }
        TypeSerializer serializer = dataType.createSerializer(null);
        ByteArrayOutputStreamWithPos baos = new ByteArrayOutputStreamWithPos();
        DataOutputViewStreamWrapper baosWrapper = new DataOutputViewStreamWrapper((OutputStream)baos);
        serializer.serialize(obj, (DataOutputView)baosWrapper);
        return pickler.dumps((Object)baos.toByteArray());
    }

    private static Object[] primitiveArrayConverter(Object array, TypeInformation<?> arrayTypeInfo) {
        Object[] objects;
        Preconditions.checkArgument((boolean)(arrayTypeInfo instanceof PrimitiveArrayTypeInfo));
        Preconditions.checkArgument((boolean)array.getClass().isArray());
        if (PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO.equals(arrayTypeInfo)) {
            boolean[] booleans = (boolean[])array;
            objects = new Object[booleans.length];
            for (int i = 0; i < booleans.length; ++i) {
                objects[i] = booleans[i];
            }
        } else if (PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO.equals(arrayTypeInfo)) {
            byte[] bytes = (byte[])array;
            objects = new Object[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                objects[i] = bytes[i];
            }
        } else if (PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO.equals(arrayTypeInfo)) {
            short[] shorts = (short[])array;
            objects = new Object[shorts.length];
            for (int i = 0; i < shorts.length; ++i) {
                objects[i] = shorts[i];
            }
        } else if (PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO.equals(arrayTypeInfo)) {
            int[] ints = (int[])array;
            objects = new Object[ints.length];
            for (int i = 0; i < ints.length; ++i) {
                objects[i] = ints[i];
            }
        } else if (PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO.equals(arrayTypeInfo)) {
            long[] longs = (long[])array;
            objects = new Object[longs.length];
            for (int i = 0; i < longs.length; ++i) {
                objects[i] = longs[i];
            }
        } else if (PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO.equals(arrayTypeInfo)) {
            float[] floats = (float[])array;
            objects = new Object[floats.length];
            for (int i = 0; i < floats.length; ++i) {
                objects[i] = Float.valueOf(floats[i]);
            }
        } else if (PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO.equals(arrayTypeInfo)) {
            double[] doubles = (double[])array;
            objects = new Object[doubles.length];
            for (int i = 0; i < doubles.length; ++i) {
                objects[i] = doubles[i];
            }
        } else if (PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO.equals(arrayTypeInfo)) {
            char[] chars = (char[])array;
            objects = new Object[chars.length];
            for (int i = 0; i < chars.length; ++i) {
                objects[i] = Character.valueOf(chars[i]);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Primitive array of %s is not supported in PyFlink yet", ((PrimitiveArrayTypeInfo)arrayTypeInfo).getComponentType().getTypeClass().getSimpleName()));
        }
        return objects;
    }
}

