/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sequencedmultisetstate.linked;

import java.util.ArrayList;
import org.apache.flink.api.common.typeutils.CompositeSerializer;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.java.typeutils.runtime.NullableSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.Node;

public class NodeSerializer
extends CompositeSerializer<Node> {
    private static final LongSerializer LONG_SERIALIZER = LongSerializer.INSTANCE;
    private static final TypeSerializer<?> NULLABLE_LONG_SERIALIZER = NullableSerializer.wrap((TypeSerializer)LONG_SERIALIZER, (boolean)true);

    public NodeSerializer(TypeSerializer<RowData> serializer) {
        this(null, NodeField.getFieldSerializers(serializer));
    }

    protected NodeSerializer(CompositeSerializer.PrecomputedParameters precomputed, TypeSerializer<?>[] originalSerializers) {
        super(CompositeSerializer.PrecomputedParameters.precompute((boolean)true, (boolean)true, originalSerializers), originalSerializers);
    }

    private NodeSerializer(TypeSerializer<?>[] nestedSerializers) {
        this(null, nestedSerializers);
    }

    public Node createInstance(Object ... values) {
        return new Node((RowData)NodeField.ROW.get(values), (Long)NodeField.SEQ_NO.get(values), (Long)NodeField.PREV_SEQ_NO.get(values), (Long)NodeField.NEXT_SEQ_NO.get(values), (Long)NodeField.NEXT_SEQ_NO_FOR_RECORD.get(values), (Long)NodeField.TIMESTAMP.get(values));
    }

    public boolean isImmutableType() {
        return true;
    }

    protected Object getField(Node node, int index) {
        return NodeField.get(node, index);
    }

    protected CompositeSerializer<Node> createSerializerInstance(CompositeSerializer.PrecomputedParameters precomputed, TypeSerializer<?> ... originalSerializers) {
        return new NodeSerializer(precomputed, originalSerializers);
    }

    public TypeSerializerSnapshot<Node> snapshotConfiguration() {
        return new NodeSerializerSnapshot(this);
    }

    protected void setField(Node value, int index, Object fieldValue) {
        throw new UnsupportedOperationException();
    }

    public static class NodeSerializerSnapshot
    extends CompositeTypeSerializerSnapshot<Node, NodeSerializer> {
        public NodeSerializerSnapshot() {
        }

        NodeSerializerSnapshot(NodeSerializer nodeSerializer) {
            super((TypeSerializer)nodeSerializer);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 0;
        }

        protected TypeSerializer<?>[] getNestedSerializers(NodeSerializer outerSerializer) {
            return outerSerializer.fieldSerializers;
        }

        protected NodeSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new NodeSerializer(nestedSerializers);
        }
    }

    private static enum NodeField {
        ROW{

            @Override
            Object get(Node node) {
                return node.getRow();
            }

            @Override
            public TypeSerializer<?> getSerializer(TypeSerializer<RowData> serializer) {
                return serializer;
            }
        }
        ,
        SEQ_NO{

            @Override
            Object get(Node node) {
                return node.getSqn();
            }

            @Override
            public TypeSerializer<?> getSerializer(TypeSerializer<RowData> serializer) {
                return LONG_SERIALIZER;
            }
        }
        ,
        PREV_SEQ_NO{

            @Override
            Object get(Node node) {
                return node.getPrevSqn();
            }

            @Override
            public TypeSerializer<?> getSerializer(TypeSerializer<RowData> serializer) {
                return NULLABLE_LONG_SERIALIZER;
            }
        }
        ,
        NEXT_SEQ_NO{

            @Override
            Object get(Node node) {
                return node.getNextSqn();
            }

            @Override
            public TypeSerializer<?> getSerializer(TypeSerializer<RowData> serializer) {
                return NULLABLE_LONG_SERIALIZER;
            }
        }
        ,
        NEXT_SEQ_NO_FOR_RECORD{

            @Override
            Object get(Node node) {
                return node.getNextSqnForRecord();
            }

            @Override
            public TypeSerializer<?> getSerializer(TypeSerializer<RowData> serializer) {
                return NULLABLE_LONG_SERIALIZER;
            }
        }
        ,
        TIMESTAMP{

            @Override
            Object get(Node node) {
                return node.getTimestamp();
            }

            @Override
            public TypeSerializer<?> getSerializer(TypeSerializer<RowData> serializer) {
                return LONG_SERIALIZER;
            }
        };


        private static TypeSerializer<?>[] getFieldSerializers(TypeSerializer<RowData> serializer) {
            ArrayList result = new ArrayList();
            for (NodeField field : NodeField.values()) {
                result.add(field.getSerializer(serializer));
            }
            return result.toArray(new TypeSerializer[0]);
        }

        public abstract TypeSerializer<?> getSerializer(TypeSerializer<RowData> var1);

        abstract Object get(Node var1);

        <T> T get(Object ... values) {
            return (T)values[this.ordinal()];
        }

        public static Object get(Node node, int field) {
            return NodeField.values()[field].get(node);
        }
    }
}

