/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNonTimeUnboundedPrecedingOver<K>
extends KeyedProcessFunction<K, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNonTimeUnboundedPrecedingOver.class);
    private final long stateRetentionTime;
    private final GeneratedAggsHandleFunction generatedAggsHandler;
    private final GeneratedRecordEqualiser generatedRecordEqualiser;
    private final GeneratedRecordEqualiser generatedSortKeyEqualiser;
    private final GeneratedRecordComparator generatedSortKeyComparator;
    private transient Comparator<RowData> sortKeyComparator;
    final KeySelector<RowData, RowData> sortKeySelector;
    transient RecordEqualiser valueEqualiser;
    private transient RecordEqualiser sortKeyEqualiser;
    private final LogicalType[] accTypes;
    private final LogicalType[] inputFieldTypes;
    private final LogicalType[] sortKeyTypes;
    private final InternalTypeInfo<RowData> accKeyRowTypeInfo;
    transient JoinedRowData output;
    transient ValueState<Long> idState;
    @VisibleForTesting
    transient ValueStateDescriptor<Long> idStateDescriptor;
    transient ValueState<List<Tuple2<RowData, List<Long>>>> sortedListState;
    @VisibleForTesting
    transient ValueStateDescriptor<List<Tuple2<RowData, List<Long>>>> sortedListStateDescriptor;
    transient MapState<Long, RowData> valueMapState;
    @VisibleForTesting
    transient MapStateDescriptor<Long, RowData> valueStateDescriptor;
    transient MapState<RowData, RowData> accMapState;
    @VisibleForTesting
    transient MapStateDescriptor<RowData, RowData> accStateDescriptor;
    transient AggsHandleFunction aggFuncs;
    private static final String IDS_NOT_FOUND_METRIC_NAME = "numOfIdsNotFound";
    transient Counter numOfIdsNotFound;
    private static final String SORT_KEYS_NOT_FOUND_METRIC_NAME = "numOfSortKeysNotFound";
    transient Counter numOfSortKeysNotFound;

    @VisibleForTesting
    protected Counter getNumOfIdsNotFound() {
        return this.numOfIdsNotFound;
    }

    @VisibleForTesting
    protected Counter getNumOfSortKeysNotFound() {
        return this.numOfSortKeysNotFound;
    }

    public AbstractNonTimeUnboundedPrecedingOver(long stateRetentionTime, GeneratedAggsHandleFunction genAggsHandler, GeneratedRecordEqualiser genRecordEqualiser, GeneratedRecordEqualiser genSortKeyEqualiser, GeneratedRecordComparator genSortKeyComparator, LogicalType[] accTypes, LogicalType[] inputFieldTypes, LogicalType[] sortKeyTypes, RowDataKeySelector sortKeySelector, InternalTypeInfo<RowData> accKeyRowTypeInfo) {
        this.stateRetentionTime = stateRetentionTime;
        this.generatedAggsHandler = genAggsHandler;
        this.generatedRecordEqualiser = genRecordEqualiser;
        this.generatedSortKeyEqualiser = genSortKeyEqualiser;
        this.generatedSortKeyComparator = genSortKeyComparator;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.sortKeyTypes = sortKeyTypes;
        this.sortKeySelector = sortKeySelector;
        this.accKeyRowTypeInfo = accKeyRowTypeInfo;
    }

    public void open(OpenContext openContext) throws Exception {
        this.aggFuncs = (AggsHandleFunction)this.generatedAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.aggFuncs.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRowData();
        this.valueEqualiser = (RecordEqualiser)this.generatedRecordEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.sortKeyEqualiser = (RecordEqualiser)this.generatedSortKeyEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.sortKeyComparator = (Comparator)this.generatedSortKeyComparator.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        StateTtlConfig ttlConfig = StateConfigUtil.createTtlConfig(this.stateRetentionTime);
        this.idStateDescriptor = new ValueStateDescriptor("idState", Long.class);
        if (ttlConfig.isEnabled()) {
            this.idStateDescriptor.enableTimeToLive(ttlConfig);
        }
        this.idState = this.getRuntimeContext().getState(this.idStateDescriptor);
        InternalTypeInfo<RowData> inputRowTypeInfo = InternalTypeInfo.ofFields(this.inputFieldTypes);
        InternalTypeInfo<RowData> sortKeyRowTypeInfo = InternalTypeInfo.ofFields(this.sortKeyTypes);
        ListTypeInfo idListTypeInfo = new ListTypeInfo(Types.LONG);
        ListTypeInfo listTypeInfo = new ListTypeInfo((TypeInformation)new TupleTypeInfo(new TypeInformation[]{sortKeyRowTypeInfo, idListTypeInfo}));
        this.sortedListStateDescriptor = new ValueStateDescriptor("sortedListState", (TypeInformation)listTypeInfo);
        if (ttlConfig.isEnabled()) {
            this.sortedListStateDescriptor.enableTimeToLive(ttlConfig);
        }
        this.sortedListState = this.getRuntimeContext().getState(this.sortedListStateDescriptor);
        this.valueStateDescriptor = new MapStateDescriptor("valueMapState", Types.LONG, inputRowTypeInfo);
        if (ttlConfig.isEnabled()) {
            this.valueStateDescriptor.enableTimeToLive(ttlConfig);
        }
        this.valueMapState = this.getRuntimeContext().getMapState(this.valueStateDescriptor);
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        this.accStateDescriptor = new MapStateDescriptor("accMapState", this.accKeyRowTypeInfo, accTypeInfo);
        if (ttlConfig.isEnabled()) {
            this.accStateDescriptor.enableTimeToLive(ttlConfig);
        }
        this.accMapState = this.getRuntimeContext().getMapState(this.accStateDescriptor);
        this.numOfIdsNotFound = this.getRuntimeContext().getMetricGroup().counter(IDS_NOT_FOUND_METRIC_NAME);
        this.numOfSortKeysNotFound = this.getRuntimeContext().getMetricGroup().counter(SORT_KEYS_NOT_FOUND_METRIC_NAME);
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        RowKind rowKind = input.getRowKind();
        switch (rowKind) {
            case INSERT: 
            case UPDATE_AFTER: {
                this.insertIntoSortedList(input, out);
                break;
            }
            case DELETE: 
            case UPDATE_BEFORE: {
                this.removeFromSortedList(input, out);
            }
        }
        this.aggFuncs.resetAccumulators();
        this.aggFuncs.cleanup();
    }

    abstract void insertIntoSortedList(RowData var1, Collector<RowData> var2) throws Exception;

    abstract void processRemainingElements(List<Tuple2<RowData, List<Long>>> var1, int var2, RowData var3, Collector<RowData> var4) throws Exception;

    abstract void reAccumulateIdsAfterInsert(RowData var1, List<Long> var2, RowData var3) throws Exception;

    Long getNextId() throws IOException {
        Long id = (Long)this.idState.value();
        if (id == null) {
            id = Long.MIN_VALUE;
        }
        return id;
    }

    List<Tuple2<RowData, List<Long>>> getSortedList() throws IOException {
        ArrayList sortedList = (ArrayList)this.sortedListState.value();
        if (sortedList == null) {
            sortedList = new ArrayList();
        }
        return sortedList;
    }

    Tuple2<Integer, Boolean> findIndexOfSortKey(List<Tuple2<RowData, List<Long>>> sortedList, RowData inputSortKey, boolean isEquals) {
        for (int i = 0; i < sortedList.size(); ++i) {
            RowData curSortKey = (RowData)sortedList.get((int)i).f0;
            if (isEquals && this.sortKeyEqualiser.equals(curSortKey, inputSortKey)) {
                return new Tuple2((Object)i, (Object)true);
            }
            int compareResult = this.sortKeyComparator.compare(curSortKey, inputSortKey);
            if (compareResult == 0) {
                return new Tuple2((Object)i, (Object)false);
            }
            if (compareResult <= 0) continue;
            return new Tuple2((Object)i, (Object)true);
        }
        return new Tuple2((Object)-1, (Object)true);
    }

    RowData setAccumulatorAndGetValue(RowData accumulator) throws Exception {
        this.aggFuncs.setAccumulators(accumulator);
        return this.aggFuncs.getValue();
    }

    abstract void sendUpdatesForIds(List<Long> var1, int var2, Collector<RowData> var3, RowKind var4, RowData var5, RowData var6, RowData var7) throws Exception;

    void emitUpdatesForIds(List<Long> ids, int idxOfChangedRow, RowData prevAcc, RowData currAcc, RowKind rowKind, RowData changedRow, Collector<RowData> out) throws Exception {
        RowData prevAggValue = this.setAccumulatorAndGetValue(prevAcc);
        RowData currAggValue = this.setAccumulatorAndGetValue(currAcc);
        if (prevAcc.equals(currAcc)) {
            this.sendUpdateForChangedRow(out, rowKind, changedRow, prevAggValue, currAggValue);
            LOG.debug("Prev accumulator is same as curr accumulator. Skipping further updates.");
            return;
        }
        this.sendUpdatesForIds(ids, idxOfChangedRow, out, rowKind, changedRow, prevAggValue, currAggValue);
    }

    void sendUpdateForChangedRow(Collector<RowData> out, RowKind rowKind, RowData changedRow, RowData prevAggValue, RowData currAggValue) {
        if (rowKind == RowKind.DELETE) {
            this.collectDelete(out, changedRow, prevAggValue);
        } else {
            this.collectInsertOrUpdateAfter(out, changedRow, rowKind, currAggValue);
        }
    }

    void collectInsertOrUpdateAfter(Collector<RowData> out, RowData value, RowKind rowKind, RowData currAggValue) {
        this.output.setRowKind(rowKind);
        this.output.replace(value, currAggValue);
        out.collect((Object)this.output);
    }

    void collectUpdateBefore(Collector<RowData> out, RowData rowValue, RowData prevAggValue) {
        this.output.setRowKind(RowKind.UPDATE_BEFORE);
        this.output.replace(rowValue, prevAggValue);
        out.collect((Object)this.output);
    }

    void collectUpdateAfter(Collector<RowData> out, RowData rowValue, RowData currAggValue) {
        this.output.setRowKind(RowKind.UPDATE_AFTER);
        this.output.replace(rowValue, currAggValue);
        out.collect((Object)this.output);
    }

    void collectDelete(Collector<RowData> out, RowData rowValue, RowData prevAggValue) {
        this.output.setRowKind(RowKind.DELETE);
        this.output.replace(rowValue, prevAggValue);
        out.collect((Object)this.output);
    }

    abstract void removeFromSortedList(RowData var1, Collector<RowData> var2) throws Exception;

    int removeIdFromSortedList(List<Tuple2<RowData, List<Long>>> sortedList, int idx, List<Long> ids, RowData curSortKey) {
        if (ids.isEmpty()) {
            sortedList.remove(idx);
        } else {
            sortedList.set(idx, (Tuple2<RowData, List<Long>>)new Tuple2((Object)curSortKey, ids));
            ++idx;
        }
        return idx;
    }

    public void close() throws Exception {
        if (null != this.aggFuncs) {
            this.aggFuncs.close();
        }
    }
}

